var _excluded = ["children", "align", "relative", "icon", "size", "flip"];

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr == null ? null : typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]; if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import './story.scss';
import { CaretDown32, CaretLeft32, CaretRight32, CaretUp32 } from '@carbon/icons-react';
import { withKnobs, boolean, select } from '@storybook/addon-knobs';
import React from 'react';
import { Popover, PopoverContent } from '../Popover';
import Button from '../Button';
import mdx from './Popover.mdx';
import { useOutsideClick } from '../../internal/useOutsideClick';
export default {
  title: 'Experimental/unstable_Popover',
  component: Popover,
  subcomponents: {
    PopoverContent: PopoverContent
  },
  decorators: [withKnobs],
  parameters: {
    docs: {
      page: mdx
    }
  },
  includeStories: ['Playground']
};
export var Default = function Default() {
  function PopoverDemo() {
    var _React$useState = React.useState('top'),
        _React$useState2 = _slicedToArray(_React$useState, 2),
        align = _React$useState2[0],
        setAlign = _React$useState2[1];

    var _React$useState3 = React.useState(true),
        _React$useState4 = _slicedToArray(_React$useState3, 2),
        open = _React$useState4[0],
        setOpen = _React$useState4[1];

    var choices = ['top', 'top-left', 'top-right', 'bottom', 'bottom-left', 'bottom-right', 'left', 'left-bottom', 'left-top', 'right', 'right-bottom', 'right-top'];
    return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement("section", null, /*#__PURE__*/React.createElement("h2", null, "Caret Position"), /*#__PURE__*/React.createElement("div", {
      style: {
        display: 'grid',
        gridTemplateColumns: 'repeat(3, auto)',
        gridGap: 8
      }
    }, choices.map(function (choice) {
      return /*#__PURE__*/React.createElement("label", {
        key: choice
      }, /*#__PURE__*/React.createElement("input", {
        type: "radio",
        name: "align",
        value: choice,
        checked: choice === align,
        onChange: function onChange() {
          setAlign(choice);
        }
      }), choice);
    }))), /*#__PURE__*/React.createElement("section", null, /*#__PURE__*/React.createElement("h2", null, "Popover Visibility"), /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement("label", null, /*#__PURE__*/React.createElement("input", {
      type: "checkbox",
      value: open,
      checked: open,
      onChange: function onChange() {
        setOpen(!open);
      }
    }), "Open"))), /*#__PURE__*/React.createElement("div", {
      style: {
        marginTop: '2rem'
      }
    }, /*#__PURE__*/React.createElement(Popover, {
      open: open,
      align: align,
      relative: true
    }, /*#__PURE__*/React.createElement(PopoverContent, {
      className: "p-3"
    }, "Hello"))));
  }

  return /*#__PURE__*/React.createElement(PopoverDemo, null);
};
export var Playground = function Playground() {
  var options = ['top', 'top-left', 'top-right', 'bottom', 'bottom-left', 'bottom-right', 'left', 'left-bottom', 'left-top', 'right', 'right-bottom', 'right-top'];
  return /*#__PURE__*/React.createElement(Popover, {
    align: select('Specify the caret alignment (align)', options, 'top'),
    caret: boolean('Specify whether the caret should be visible (caret)', true),
    highContrast: boolean('Specify whether the high-contrast variant should render (highContrast)', false),
    light: boolean('Specify whether the light variant should render (light)', false),
    open: boolean('Specify whether the popover is open or closed (open)', true)
  }, /*#__PURE__*/React.createElement(PopoverContent, {
    className: "p-3"
  }, "Sample content"));
};
Playground.story = {
  decorators: [function (story) {
    return /*#__PURE__*/React.createElement("div", {
      className: "mt-9"
    }, /*#__PURE__*/React.createElement("div", {
      className: "position-relative"
    }, story()));
  }]
};
export var Examples = function Examples() {
  function Example(_ref) {
    var children = _ref.children,
        align = _ref.align,
        _ref$relative = _ref.relative,
        relative = _ref$relative === void 0 ? false : _ref$relative,
        icon = _ref.icon,
        size = _ref.size,
        _ref$flip = _ref.flip,
        flip = _ref$flip === void 0 ? false : _ref$flip,
        rest = _objectWithoutProperties(_ref, _excluded);

    var ref = React.useRef(null);

    var _React$useState5 = React.useState(false),
        _React$useState6 = _slicedToArray(_React$useState5, 2),
        open = _React$useState6[0],
        setOpen = _React$useState6[1];

    useOutsideClick(ref, function () {
      if (open === true) {
        setOpen(false);
      }
    });

    if (flip) {
      return /*#__PURE__*/React.createElement("div", _extends({
        ref: ref
      }, rest), /*#__PURE__*/React.createElement(Popover, {
        align: align,
        open: open,
        relative: relative
      }, /*#__PURE__*/React.createElement(PopoverContent, {
        className: "p-3"
      }, children)), /*#__PURE__*/React.createElement(Button, {
        iconDescription: "Toggle",
        hasIconOnly: true,
        onClick: function onClick() {
          setOpen(!open);
        },
        renderIcon: icon,
        size: size
      }));
    }

    return /*#__PURE__*/React.createElement("div", _extends({
      ref: ref
    }, rest), /*#__PURE__*/React.createElement(Button, {
      iconDescription: "Toggle",
      hasIconOnly: true,
      onClick: function onClick() {
        setOpen(!open);
      },
      renderIcon: icon,
      size: size
    }), /*#__PURE__*/React.createElement(Popover, {
      align: align,
      open: open,
      relative: relative
    }, /*#__PURE__*/React.createElement(PopoverContent, {
      className: "p-3"
    }, children)));
  }

  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(Example, {
    className: "position-relative mb-3",
    icon: CaretDown32,
    align: "bottom-left"
  }, "This is some text"), /*#__PURE__*/React.createElement(Example, {
    className: "position-relative mb-3",
    icon: CaretDown32,
    align: "bottom-left",
    size: "sm"
  }, "This is some text"), /*#__PURE__*/React.createElement(Example, {
    className: "flex justify-center position-relative mb-3",
    icon: CaretDown32,
    align: "top"
  }, "This is some text"), /*#__PURE__*/React.createElement(Example, {
    className: "flex justify-center position-relative mb-3",
    icon: CaretDown32,
    align: "top",
    size: "sm"
  }, "This is some text"), /*#__PURE__*/React.createElement(Example, {
    className: "flex justify-end position-relative mb-3",
    icon: CaretDown32,
    align: "bottom-right"
  }, "This is some text"), /*#__PURE__*/React.createElement(Example, {
    className: "flex justify-end position-relative mb-3",
    icon: CaretDown32,
    align: "bottom-right",
    size: "sm"
  }, "This is some text"), /*#__PURE__*/React.createElement(Example, {
    className: "position-relative mb-3",
    icon: CaretUp32,
    align: "top-left"
  }, "This is some text"), /*#__PURE__*/React.createElement(Example, {
    className: "position-relative mb-3",
    icon: CaretUp32,
    align: "top-left",
    size: "sm"
  }, "This is some text"), /*#__PURE__*/React.createElement(Example, {
    className: "flex justify-center position-relative mb-3",
    icon: CaretUp32,
    align: "top"
  }, "This is some text"), /*#__PURE__*/React.createElement(Example, {
    className: "flex justify-center position-relative mb-3",
    icon: CaretUp32,
    align: "top",
    size: "sm"
  }, "This is some text"), /*#__PURE__*/React.createElement(Example, {
    className: "flex justify-end position-relative mb-3",
    icon: CaretUp32,
    align: "top-right"
  }, "This is some text"), /*#__PURE__*/React.createElement(Example, {
    className: "flex justify-end position-relative mb-3",
    icon: CaretUp32,
    align: "top-right",
    size: "sm"
  }, "This is some text"), /*#__PURE__*/React.createElement("div", {
    className: "grid grid-cols-3 mb-3"
  }, /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement(Example, {
    className: "position-relative flex align-center mb-3",
    icon: CaretRight32,
    align: "right",
    relative: true
  }, "This is some text"), /*#__PURE__*/React.createElement(Example, {
    className: "position-relative flex align-center mb-3",
    icon: CaretRight32,
    align: "right",
    size: "sm",
    relative: true
  }, "This is some text")), /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement(Example, {
    className: "position-relative flex align-center mb-3",
    icon: CaretRight32,
    align: "right-top",
    relative: true
  }, "This is some text"), /*#__PURE__*/React.createElement(Example, {
    className: "position-relative flex align-center mb-3",
    icon: CaretRight32,
    align: "right-top",
    size: "sm",
    relative: true
  }, "This is some text")), /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement(Example, {
    className: "position-relative flex align-center mb-3",
    icon: CaretRight32,
    align: "right-bottom",
    relative: true
  }, "This is some text"), /*#__PURE__*/React.createElement(Example, {
    className: "position-relative flex align-center mb-3",
    icon: CaretRight32,
    align: "right-bottom",
    size: "sm",
    relative: true
  }, "This is some text"))), /*#__PURE__*/React.createElement("div", {
    className: "grid grid-cols-3 justify-items-end mb-3"
  }, /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement(Example, {
    className: "position-relative flex align-center mb-3",
    icon: CaretLeft32,
    align: "left",
    relative: true,
    flip: true
  }, "This is some text"), /*#__PURE__*/React.createElement(Example, {
    className: "position-relative flex align-center mb-3",
    icon: CaretLeft32,
    align: "left",
    size: "sm",
    relative: true,
    flip: true
  }, "This is some text")), /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement(Example, {
    className: "position-relative flex align-center mb-3",
    icon: CaretLeft32,
    align: "left-top",
    relative: true,
    flip: true
  }, "This is some text"), /*#__PURE__*/React.createElement(Example, {
    className: "position-relative flex align-center mb-3",
    icon: CaretLeft32,
    align: "left-top",
    size: "sm",
    relative: true,
    flip: true
  }, "This is some text")), /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement(Example, {
    className: "position-relative flex align-center mb-3",
    icon: CaretLeft32,
    align: "left-bottom",
    relative: true,
    flip: true
  }, "This is some text"), /*#__PURE__*/React.createElement(Example, {
    className: "position-relative flex align-center mb-3",
    icon: CaretLeft32,
    align: "left-bottom",
    size: "sm",
    relative: true,
    flip: true
  }, "This is some text"))), /*#__PURE__*/React.createElement(Example, {
    className: "position-relative mb-3",
    icon: CaretDown32,
    align: "bottom-left"
  }, "Consectetur et sit accusamus laboriosam pariatur. Asperiores eius expedita eligendi beatae vero commodi harum Illo hic accusamus fugit commodi cupiditate Explicabo distinctio quisquam culpa fugit eius Provident voluptatum ipsam quo."));
};