function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/**
 * Copyright IBM Corp. 2021
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React from 'react';
import PropTypes from 'prop-types';
import classNames from 'classnames';
import { settings } from 'carbon-components';
import { useId } from '../../internal/useId';
var prefix = settings.prefix;

function ProgressBar(_ref) {
  var className = _ref.className,
      hideLabel = _ref.hideLabel,
      label = _ref.label,
      _ref$max = _ref.max,
      max = _ref$max === void 0 ? 100 : _ref$max,
      value = _ref.value,
      helperText = _ref.helperText;
  var id = useId('progress-bar');
  var helperId = useId('progress-bar-helper');
  var indeterminate = value === null || value === undefined;
  var cappedValue = value;

  if (cappedValue > max) {
    cappedValue = max;
  }

  if (cappedValue < 0) {
    cappedValue = 0;
  }

  var percentage = cappedValue / max;
  var wrapperClasses = classNames("".concat(prefix, "--progress-bar"), _defineProperty({}, "".concat(prefix, "--progress-bar--indeterminate"), indeterminate), className);
  var labelClasses = classNames("".concat(prefix, "--progress-bar__label"), _defineProperty({}, "".concat(prefix, "--visually-hidden"), hideLabel));
  return /*#__PURE__*/React.createElement("div", {
    className: wrapperClasses
  }, /*#__PURE__*/React.createElement("label", {
    className: labelClasses,
    htmlFor: id
  }, label), /*#__PURE__*/React.createElement("div", {
    className: "".concat(prefix, "--progress-bar__track"),
    id: id,
    role: "progressbar",
    "aria-valuemin": !indeterminate ? 0 : null,
    "aria-valuemax": !indeterminate ? max : null,
    "aria-valuenow": !indeterminate ? cappedValue : null,
    "aria-describedby": helperText ? helperId : null
  }, /*#__PURE__*/React.createElement("div", {
    className: "".concat(prefix, "--progress-bar__bar"),
    style: {
      transform: "scaleX(".concat(percentage, ")")
    }
  })), helperText && /*#__PURE__*/React.createElement("div", {
    id: helperId,
    className: "".concat(prefix, "--progress-bar__helper-text")
  }, helperText));
}

ProgressBar.propTypes = {
  /**
   * Additional CSS class names.
   */
  className: PropTypes.string,

  /**
   * The current progress as a textual representation.
   */
  helperText: PropTypes.string,

  /**
   * Whether the label should be visually hidden.
   */
  hideLabel: PropTypes.bool,

  /**
   * A label describing the progress bar.
   */
  label: PropTypes.string.isRequired,

  /**
   * The maximum value.
   */
  max: PropTypes.number,

  /**
   * The current value.
   */
  value: PropTypes.number
};
export default ProgressBar;