function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React from 'react';
import { action } from '@storybook/addon-actions';
import { withKnobs, boolean, text, select as _select } from '@storybook/addon-knobs';
import Select from '../Select';
import SelectItem from '../SelectItem';
import SelectItemGroup from '../SelectItemGroup';
import SelectSkeleton from '../Select/Select.Skeleton';
import mdx from './Select.mdx';
var sizes = {
  'Small  (sm)': 'sm',
  'Medium (md) - default': undefined,
  'Large  (lg)': 'lg'
};
var props = {
  select: function select() {
    return {
      className: 'some-class',
      light: boolean('Light variant (light in <Select>)', false),
      inline: boolean('Put control in-line with label (inline in <Select>)', false),
      size: _select('Field size (size)', sizes, undefined) || undefined,
      disabled: boolean('Disabled (disabled in <Select>)', false),
      hideLabel: boolean('No label (hideLabel in <Select>)', false),
      invalid: boolean('Show form validation UI (invalid in <Select>)', false),
      invalidText: text('Form validation UI content (invalidText in <Select>)', 'A valid value is required'),
      labelText: text('Label text (labelText)', 'Select'),
      helperText: text('Helper text (helperText)', 'Optional helper text.'),
      onChange: action('onChange'),
      warn: boolean('Show warning state (warn)', false),
      warnText: text('Warning state text (warnText)', 'This will overwrite your current settings')
    };
  },
  group: function group() {
    return {
      disabled: boolean('Disabled (disabled in <SelectItemGroup>)', false)
    };
  }
};
export default {
  title: 'Components/Select',
  decorators: [withKnobs],
  parameters: {
    component: Select,
    docs: {
      page: mdx
    },
    subcomponents: {
      SelectItem: SelectItem,
      SelectItemGroup: SelectItemGroup,
      SelectSkeleton: SelectSkeleton
    }
  }
};
export var Default = function Default() {
  var groupProps = props.group();
  return /*#__PURE__*/React.createElement("div", {
    style: {
      width: 400
    }
  }, /*#__PURE__*/React.createElement(Select, _extends({}, props.select(), {
    id: "select-1",
    defaultValue: "placeholder-item"
  }), /*#__PURE__*/React.createElement(SelectItem, {
    disabled: true,
    hidden: true,
    value: "placeholder-item",
    text: "Choose an option"
  }), /*#__PURE__*/React.createElement(SelectItemGroup, _extends({
    label: "Category 1"
  }, groupProps), /*#__PURE__*/React.createElement(SelectItem, {
    value: "option-1",
    text: "Option 1"
  }), /*#__PURE__*/React.createElement(SelectItem, {
    value: "option-2",
    text: "Option 2"
  })), /*#__PURE__*/React.createElement(SelectItemGroup, _extends({
    label: "Category 2"
  }, groupProps), /*#__PURE__*/React.createElement(SelectItem, {
    value: "option-3",
    text: "Option 3"
  }), /*#__PURE__*/React.createElement(SelectItem, {
    value: "option-4",
    text: "Option 4"
  }))));
};
Default.parameters = {
  info: {
    text: "\n        Select displays a list below its title when selected. They are used primarily in forms,\n        where a user chooses one option from a list. Once the user selects an item, the dropdown will\n        disappear and the field will reflect the user's choice. Create Select Item components for each\n        option in the list. The example below shows an enabled Select component with three items.\n      "
  }
};
export var Skeleton = function Skeleton() {
  return /*#__PURE__*/React.createElement("div", {
    style: {
      width: '300px'
    },
    "aria-label": "loading select",
    "aria-live": "assertive",
    role: "status",
    tabIndex: "0" // eslint-disable-line jsx-a11y/no-noninteractive-tabindex

  }, /*#__PURE__*/React.createElement(SelectSkeleton, null));
};
Skeleton.storyName = 'skeleton';
Skeleton.parameters = {
  info: {
    text: "\n        Placeholder skeleton state to use when content is loading.\n      "
  }
};