function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr == null ? null : typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]; if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React, { useState } from 'react';
import { action } from '@storybook/addon-actions';
import { withKnobs, boolean, number, text } from '@storybook/addon-knobs';
import Slider from '../Slider';
import SliderSkeleton from '../Slider/Slider.Skeleton';
import { sliderValuePropSync } from '../../internal/FeatureFlags';
import mdx from './Slider.mdx';

var props = function props() {
  return {
    name: text('Form item name (name)', ''),
    inputType: text('The form element type (inputType)', 'number'),
    ariaLabelInput: text('The ARIA label for the <input> (ariaLabelInput)', 'Label for slider value'),
    disabled: boolean('Disabled (disabled)', false),
    light: boolean('Light variant (light)', false),
    hideTextInput: boolean('Without text input (hideTextInput)', false),
    value: !sliderValuePropSync ? 50 : number('The value (value)', 50),
    min: number('The minimum value (min)', 0),
    max: number('The maximum value (max)', 100),
    step: number('The step (step)', 1),
    stepMultiplier: number('The step factor for Shift+arrow keys (stepMultiplier)', 5),
    labelText: text('Label text (labelText)', 'Slider Label'),
    minLabel: text('Label for minimum value (minLabel)', ''),
    maxLabel: text('Label for maximum value (maxLabel)', ''),
    onChange: action('onChange'),
    onRelease: action('onRelease')
  };
};

export default {
  title: 'Components/Slider',
  decorators: [withKnobs],
  parameters: {
    component: Slider,
    docs: {
      page: mdx
    },
    subcomponents: {
      SliderSkeleton: SliderSkeleton
    }
  }
};
export var Default = function Default() {
  return /*#__PURE__*/React.createElement(Slider, {
    labelText: "Slider Label",
    value: 50,
    min: 0,
    max: 100,
    step: 1,
    stepMultiplier: 10,
    novalidate: true
  });
};
Default.story = {
  name: 'Slider'
};
export var Playground = function Playground() {
  return /*#__PURE__*/React.createElement(Slider, _extends({
    id: "slider"
  }, props()));
};
export var ControlledSlider = function ControlledSlider() {
  var _useState = useState(87),
      _useState2 = _slicedToArray(_useState, 2),
      val = _useState2[0],
      setVal = _useState2[1];

  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement("button", {
    type: "button",
    onClick: function onClick() {
      return setVal(Math.round(Math.random() * 100));
    }
  }, "randomize value"), /*#__PURE__*/React.createElement(Slider, {
    max: 100,
    min: 0,
    value: val,
    onChange: function onChange(_ref) {
      var value = _ref.value;
      return setVal(value);
    }
  }), /*#__PURE__*/React.createElement("h1", null, val));
};
export var Skeleton = function Skeleton() {
  return /*#__PURE__*/React.createElement(SliderSkeleton, null);
};