var _excluded = ["children", "selection", "className", "ariaLabel", "isCondensed", "isFlush", "border"],
    _excluded2 = ["children", "className"],
    _excluded3 = ["children", "className"],
    _excluded4 = ["onKeyDown", "tabIndex", "children", "className", "head", "label"],
    _excluded5 = ["className", "value", "name", "title", "id"],
    _excluded6 = ["children", "className", "head", "noWrap"];

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React from 'react';
import PropTypes from 'prop-types';
import classNames from 'classnames';
import { settings } from 'carbon-components';
import setupGetInstanceId from '../../tools/setupGetInstanceId';
import deprecate from '../../prop-types/deprecate';
var prefix = settings.prefix;
var getInstanceId = setupGetInstanceId();
export function StructuredListWrapper(props) {
  var _classNames;

  var children = props.children,
      selection = props.selection,
      className = props.className,
      ariaLabel = props.ariaLabel,
      isCondensed = props.isCondensed,
      isFlush = props.isFlush,
      _border = props.border,
      other = _objectWithoutProperties(props, _excluded);

  var classes = classNames("".concat(prefix, "--structured-list"), className, (_classNames = {}, _defineProperty(_classNames, "".concat(prefix, "--structured-list--selection"), selection), _defineProperty(_classNames, "".concat(prefix, "--structured-list--condensed"), isCondensed), _defineProperty(_classNames, "".concat(prefix, "--structured-list--flush"), isFlush), _classNames));
  return /*#__PURE__*/React.createElement("div", _extends({
    role: "table",
    className: classes
  }, other, {
    "aria-label": ariaLabel
  }), children);
}
StructuredListWrapper.propTypes = {
  /**
   * Specify a label to be read by screen readers on the container node
   */
  ariaLabel: PropTypes.string,

  /**
   * Specify whether a border should be added to your StructuredListWrapper
   */
  border: deprecate(PropTypes.bool, "\nThe prop `border` will be removed in the next major version of Carbon."),

  /**
   * Provide the contents of your StructuredListWrapper
   */
  children: PropTypes.node,

  /**
   * Specify an optional className to be applied to the container node
   */
  className: PropTypes.string,

  /**
   * Specify if structured list is condensed, default is false
   */
  isCondensed: PropTypes.bool,

  /**
   * Specify if structured list is flush, default is false
   */
  isFlush: PropTypes.bool,

  /**
   * Specify whether your StructuredListWrapper should have selections
   */
  selection: PropTypes.bool
};
StructuredListWrapper.defaultProps = {
  selection: false,
  ariaLabel: 'Structured list section',
  isCondensed: false,
  isFlush: false
};
export function StructuredListHead(props) {
  var children = props.children,
      className = props.className,
      other = _objectWithoutProperties(props, _excluded2);

  var classes = classNames("".concat(prefix, "--structured-list-thead"), className);
  return /*#__PURE__*/React.createElement("div", _extends({
    role: "rowgroup",
    className: classes
  }, other), children);
}
StructuredListHead.propTypes = {
  /**
   * Provide the contents of your StructuredListHead
   */
  children: PropTypes.node,

  /**
   * Specify an optional className to be applied to the node
   */
  className: PropTypes.string
};
export function StructuredListBody(props) {
  var children = props.children,
      className = props.className,
      other = _objectWithoutProperties(props, _excluded3);

  var classes = classNames("".concat(prefix, "--structured-list-tbody"), className);
  return /*#__PURE__*/React.createElement("div", _extends({
    className: classes,
    role: "rowgroup"
  }, other), children);
}
StructuredListBody.propTypes = {
  /**
   * Provide the contents of your StructuredListBody
   */
  children: PropTypes.node,

  /**
   * Specify an optional className to be applied to the container node
   */
  className: PropTypes.string,
  head: PropTypes.bool,

  /**
   * Provide a handler that is invoked on the key down event for the control
   */
  onKeyDown: PropTypes.func
};
StructuredListBody.defaultProps = {
  onKeyDown: function onKeyDown() {}
};
export function StructuredListRow(props) {
  var onKeyDown = props.onKeyDown,
      tabIndex = props.tabIndex,
      children = props.children,
      className = props.className,
      head = props.head,
      label = props.label,
      other = _objectWithoutProperties(props, _excluded4);

  var classes = classNames("".concat(prefix, "--structured-list-row"), className, _defineProperty({}, "".concat(prefix, "--structured-list-row--header-row"), head));
  return label ?
  /*#__PURE__*/
  // eslint-disable-next-line jsx-a11y/no-noninteractive-element-interactions
  React.createElement("label", _extends({}, other, {
    tabIndex: tabIndex,
    className: classes,
    onKeyDown: onKeyDown
  }), children) : /*#__PURE__*/React.createElement("div", _extends({
    role: "row"
  }, other, {
    className: classes
  }), children);
}
StructuredListRow.propTypes = {
  /**
   * Provide the contents of your StructuredListRow
   */
  children: PropTypes.node,

  /**
   * Specify an optional className to be applied to the container node
   */
  className: PropTypes.string,

  /**
   * Specify whether your StructuredListRow should be used as a header row
   */
  head: PropTypes.bool,

  /**
   * Specify whether a `<label>` should be used
   */
  label: PropTypes.bool,

  /**
   * Provide a handler that is invoked on the key down event for the control,
   * if `<label>` is in use
   */
  onKeyDown: PropTypes.func,

  /**
   * Specify the tab index of the container node, if `<label>` is in use
   */
  tabIndex: PropTypes.number
};
StructuredListRow.defaultProps = {
  head: false,
  label: false,
  tabIndex: 0,
  onKeyDown: function onKeyDown() {}
};
export function StructuredListInput(props) {
  var className = props.className,
      value = props.value,
      name = props.name,
      title = props.title,
      id = props.id,
      other = _objectWithoutProperties(props, _excluded5);

  var classes = classNames("".concat(prefix, "--structured-list-input"), className);
  var instanceId = id || getInstanceId();
  return /*#__PURE__*/React.createElement("input", _extends({}, other, {
    type: "radio",
    tabIndex: -1,
    id: instanceId,
    className: classes,
    value: value,
    name: name,
    title: title
  }));
}
StructuredListInput.propTypes = {
  /**
   * Specify an optional className to be applied to the input
   */
  className: PropTypes.string,

  /**
   * Specify whether the underlying input should be checked by default
   */
  defaultChecked: PropTypes.bool,

  /**
   * Specify a custom `id` for the input
   */
  id: PropTypes.string,

  /**
   * Provide a `name` for the input
   */
  name: PropTypes.string,

  /**
   * Provide an optional hook that is called each time the input is updated
   */
  onChange: PropTypes.func,

  /**
   * Provide a `title` for the input
   */
  title: PropTypes.string,

  /**
   * Specify the value of the input
   */
  value: PropTypes.oneOfType([PropTypes.string, PropTypes.number]).isRequired
};
StructuredListInput.defaultProps = {
  onChange: function onChange() {},
  value: 'value',
  title: 'title'
};
export function StructuredListCell(props) {
  var _classNames3;

  var children = props.children,
      className = props.className,
      head = props.head,
      noWrap = props.noWrap,
      other = _objectWithoutProperties(props, _excluded6);

  var classes = classNames(className, (_classNames3 = {}, _defineProperty(_classNames3, "".concat(prefix, "--structured-list-th"), head), _defineProperty(_classNames3, "".concat(prefix, "--structured-list-td"), !head), _defineProperty(_classNames3, "".concat(prefix, "--structured-list-content--nowrap"), noWrap), _classNames3));
  return /*#__PURE__*/React.createElement("div", _extends({
    className: classes,
    role: head ? 'columnheader' : 'cell'
  }, other), children);
}
StructuredListCell.propTypes = {
  /**
   * Provide the contents of your StructuredListCell
   */
  children: PropTypes.node,

  /**
   * Specify an optional className to be applied to the container node
   */
  className: PropTypes.string,

  /**
   * Specify whether your StructuredListCell should be used as a header cell
   */
  head: PropTypes.bool,

  /**
   * Specify whether your StructuredListCell should have text wrapping
   */
  noWrap: PropTypes.bool
};
StructuredListCell.defaultProps = {
  head: false,
  noWrap: false
};