function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

var _excluded = ["children", "className", "light"],
    _excluded2 = ["children", "href", "className", "handleClick", "handleKeyDown", "clicked", "light"],
    _excluded3 = ["children", "id", "tabIndex", "value", "name", "title", "iconDescription", "className", "handleClick", "handleKeyDown", "onClick", "onChange", "onKeyDown", "light", "disabled", "selected"],
    _excluded4 = ["tabIndex", "className", "expanded", "tileMaxHeight", "tilePadding", "handleClick", "onClick", "onKeyUp", "tileCollapsedIconText", "tileExpandedIconText", "tileCollapsedLabel", "tileExpandedLabel", "onBeforeClick", "light"];

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr == null ? null : typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]; if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React, { Component, useEffect, useRef, useState } from 'react';
import PropTypes from 'prop-types';
import classNames from 'classnames';
import { settings } from 'carbon-components';
import Link from '../Link';
import { Checkbox16, CheckboxCheckedFilled16, ChevronDown16 } from '@carbon/icons-react';
import { keys, matches } from '../../internal/keyboard';
import deprecate from '../../prop-types/deprecate';
import { composeEventHandlers } from '../../tools/events';
var prefix = settings.prefix;
export var Tile = /*#__PURE__*/function (_Component) {
  _inherits(Tile, _Component);

  var _super = _createSuper(Tile);

  function Tile() {
    _classCallCheck(this, Tile);

    return _super.apply(this, arguments);
  }

  _createClass(Tile, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          children = _this$props.children,
          className = _this$props.className,
          light = _this$props.light,
          other = _objectWithoutProperties(_this$props, _excluded);

      var tileClasses = classNames("".concat(prefix, "--tile"), _defineProperty({}, "".concat(prefix, "--tile--light"), light), className);
      return /*#__PURE__*/React.createElement("div", _extends({
        className: tileClasses
      }, other), children);
    }
  }]);

  return Tile;
}(Component);

_defineProperty(Tile, "propTypes", {
  /**
   * The child nodes.
   */
  children: PropTypes.node,

  /**
   * The CSS class names.
   */
  className: PropTypes.string,

  /**
   * `true` to use the light version. For use on $ui-01 backgrounds only.
   * Don't use this to make tile background color same as container background color.
   */
  light: PropTypes.bool
});

_defineProperty(Tile, "defaultProps", {
  light: false
});

export var ClickableTile = /*#__PURE__*/function (_Component2) {
  _inherits(ClickableTile, _Component2);

  var _super2 = _createSuper(ClickableTile);

  function ClickableTile() {
    var _this;

    _classCallCheck(this, ClickableTile);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super2.call.apply(_super2, [this].concat(args));

    _defineProperty(_assertThisInitialized(_this), "state", {});

    _defineProperty(_assertThisInitialized(_this), "handleClick", function (evt) {
      evt.persist();

      _this.setState({
        clicked: !_this.state.clicked
      }, function () {
        _this.props.handleClick(evt);
      });
    });

    _defineProperty(_assertThisInitialized(_this), "handleKeyDown", function (evt) {
      evt.persist();

      if (matches(evt, [keys.Enter, keys.Space])) {
        _this.setState({
          clicked: !_this.state.clicked
        }, function () {
          _this.props.handleKeyDown(evt);
        });
      } else {
        _this.props.handleKeyDown(evt);
      }
    });

    return _this;
  }

  _createClass(ClickableTile, [{
    key: "render",
    value: function render() {
      var _classNames2;

      var _this$props2 = this.props,
          children = _this$props2.children,
          href = _this$props2.href,
          className = _this$props2.className,
          handleClick = _this$props2.handleClick,
          handleKeyDown = _this$props2.handleKeyDown,
          clicked = _this$props2.clicked,
          light = _this$props2.light,
          other = _objectWithoutProperties(_this$props2, _excluded2);

      var classes = classNames("".concat(prefix, "--tile"), "".concat(prefix, "--tile--clickable"), (_classNames2 = {}, _defineProperty(_classNames2, "".concat(prefix, "--tile--is-clicked"), this.state.clicked), _defineProperty(_classNames2, "".concat(prefix, "--tile--light"), light), _classNames2), className);
      return /*#__PURE__*/React.createElement(Link, _extends({
        href: href,
        className: classes
      }, other, {
        onClick: this.handleClick,
        onKeyDown: this.handleKeyDown
      }), children);
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: // eslint-disable-next-line react/prop-types
    function getDerivedStateFromProps(_ref, state) {
      var clicked = _ref.clicked;
      var prevClicked = state.prevClicked;
      return prevClicked === clicked ? null : {
        clicked: clicked,
        prevClicked: clicked
      };
    }
  }]);

  return ClickableTile;
}(Component);

_defineProperty(ClickableTile, "propTypes", {
  /**
   * The child nodes.
   */
  children: PropTypes.node,

  /**
   * The CSS class names.
   */
  className: PropTypes.string,

  /**
   * Specify the function to run when the ClickableTile is clicked
   */
  handleClick: PropTypes.func,

  /**
   * Specify the function to run when the ClickableTile is interacted with via a keyboard
   */
  handleKeyDown: PropTypes.func,

  /**
   * The href for the link.
   */
  href: PropTypes.string,

  /**
   * `true` to use the light version. For use on $ui-01 backgrounds only.
   * Don't use this to make tile background color same as container background color.
   */
  light: PropTypes.bool,

  /**
   * The rel property for the link.
   */
  rel: PropTypes.string
});

_defineProperty(ClickableTile, "defaultProps", {
  clicked: false,
  handleClick: function handleClick() {},
  handleKeyDown: function handleKeyDown() {},
  light: false
});

export function SelectableTile(props) {
  var _classNames3;

  var children = props.children,
      id = props.id,
      _props$tabIndex = props.tabIndex,
      tabIndex = _props$tabIndex === void 0 ? 0 : _props$tabIndex,
      value = props.value,
      name = props.name,
      title = props.title,
      iconDescription = props.iconDescription,
      className = props.className,
      handleClick = props.handleClick,
      handleKeyDown = props.handleKeyDown,
      _props$onClick = props.onClick,
      onClick = _props$onClick === void 0 ? function () {} : _props$onClick,
      _props$onChange = props.onChange,
      onChange = _props$onChange === void 0 ? function () {} : _props$onChange,
      _props$onKeyDown = props.onKeyDown,
      onKeyDown = _props$onKeyDown === void 0 ? function () {} : _props$onKeyDown,
      light = props.light,
      disabled = props.disabled,
      selected = props.selected,
      other = _objectWithoutProperties(props, _excluded3); // TODO: replace with onClick when handleClick prop is deprecated


  var clickHandler = handleClick || onClick; // TODO: replace with onClick when handleClick prop is deprecated

  var keyDownHandler = handleKeyDown || onKeyDown;

  var _useState = useState(selected),
      _useState2 = _slicedToArray(_useState, 2),
      isSelected = _useState2[0],
      setIsSelected = _useState2[1];

  var input = useRef(null);
  var classes = classNames("".concat(prefix, "--tile"), "".concat(prefix, "--tile--selectable"), (_classNames3 = {}, _defineProperty(_classNames3, "".concat(prefix, "--tile--is-selected"), isSelected), _defineProperty(_classNames3, "".concat(prefix, "--tile--light"), light), _defineProperty(_classNames3, "".concat(prefix, "--tile--disabled"), disabled), _classNames3), className);
  var inputClasses = classNames("".concat(prefix, "--tile-input"), _defineProperty({}, "".concat(prefix, "--tile-input--checked"), isSelected)); // TODO: rename to handleClick when handleClick prop is deprecated

  function handleOnClick(evt) {
    evt.preventDefault();
    evt.persist();
    setIsSelected(!isSelected);
    clickHandler(evt);
    onChange(evt);
  } // TODO: rename to handleKeyDown when handleKeyDown prop is deprecated


  function handleOnKeyDown(evt) {
    evt.persist();

    if (matches(evt, [keys.Enter, keys.Space])) {
      evt.preventDefault();
      setIsSelected(!isSelected);
      onChange(evt);
    }

    keyDownHandler(evt);
  }

  function handleChange(event) {
    setIsSelected(event.target.checked);
    onChange(event);
  }

  useEffect(function () {
    setIsSelected(selected);
  }, [selected]);
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement("input", {
    ref: input,
    tabIndex: -1,
    id: id,
    className: inputClasses,
    value: value,
    onChange: !disabled ? handleChange : null,
    type: "checkbox",
    disabled: disabled,
    name: name,
    title: title,
    checked: isSelected
  }), /*#__PURE__*/React.createElement("label", _extends({
    htmlFor: id,
    className: classes // eslint-disable-next-line jsx-a11y/no-noninteractive-tabindex
    ,
    tabIndex: !disabled ? tabIndex : null
  }, other, {
    onClick: !disabled ? handleOnClick : null,
    onKeyDown: !disabled ? handleOnKeyDown : null
  }), /*#__PURE__*/React.createElement("span", {
    className: "".concat(prefix, "--tile__checkmark ").concat(prefix, "--tile__checkmark--persistent")
  }, isSelected ? /*#__PURE__*/React.createElement(CheckboxCheckedFilled16, null) : /*#__PURE__*/React.createElement(Checkbox16, null)), /*#__PURE__*/React.createElement("span", {
    className: "".concat(prefix, "--tile-content")
  }, children)));
}
SelectableTile.defaultProps = {
  value: 'value',
  title: 'title',
  selected: false,
  tabIndex: 0,
  light: false
};
SelectableTile.propTypes = {
  /**
   * The child nodes.
   */
  children: PropTypes.node,

  /**
   * The CSS class names.
   */
  className: PropTypes.string,

  /**
   * Specify whether the SelectableTile should be disabled
   */
  disabled: PropTypes.bool,

  /**
   * Specify the function to run when the SelectableTile is clicked
   */
  handleClick: deprecate(PropTypes.func, 'The `handleClick` prop for `SelectableTile` has been deprecated in favor of `onClick`. It will be removed in the next major release.'),

  /**
   * Specify the function to run when the SelectableTile is interacted with via a keyboard
   */
  handleKeyDown: deprecate(PropTypes.func, 'The `handleKeyDown` prop for `SelectableTile` has been deprecated in favor of `onKeyDown`. It will be removed in the next major release.'),

  /**
   * The description of the checkmark icon.
   */
  iconDescription: deprecate(PropTypes.string, 'The `iconDescription` prop for `SelectableTile` is no longer needed and has ' + 'been deprecated. It will be removed in the next major release.'),

  /**
   * The ID of the `<input>`.
   */
  id: PropTypes.string,

  /**
   * `true` to use the light version. For use on $ui-01 backgrounds only.
   * Don't use this to make tile background color same as container background color.
   */
  light: PropTypes.bool,

  /**
   * The `name` of the `<input>`.
   */
  name: PropTypes.string,

  /**
   * The empty handler of the `<input>`.
   */
  onChange: PropTypes.func,

  /**
   * Specify the function to run when the SelectableTile is clicked
   */
  onClick: PropTypes.func,

  /**
   * Specify the function to run when the SelectableTile is interacted with via a keyboard
   */
  onKeyDown: PropTypes.func,

  /**
   * `true` to select this tile.
   */
  selected: PropTypes.bool,

  /**
   * Specify the tab index of the wrapper element
   */
  tabIndex: PropTypes.number,

  /**
   * The `title` of the `<input>`.
   */
  title: PropTypes.string,

  /**
   * The value of the `<input>`.
   */
  value: PropTypes.oneOfType([PropTypes.string, PropTypes.number]).isRequired
};
export var ExpandableTile = /*#__PURE__*/function (_Component3) {
  _inherits(ExpandableTile, _Component3);

  var _super3 = _createSuper(ExpandableTile);

  function ExpandableTile() {
    var _this2;

    _classCallCheck(this, ExpandableTile);

    for (var _len2 = arguments.length, args = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
      args[_key2] = arguments[_key2];
    }

    _this2 = _super3.call.apply(_super3, [this].concat(args));

    _defineProperty(_assertThisInitialized(_this2), "state", {});

    _defineProperty(_assertThisInitialized(_this2), "componentDidMount", function () {
      if (_this2.tile) {
        var getStyle = window.getComputedStyle(_this2.tile, null);

        if (_this2.aboveTheFold) {
          _this2.setState({
            tileMaxHeight: _this2.aboveTheFold.getBoundingClientRect().height,
            tilePadding: parseInt(getStyle.getPropertyValue('padding-top'), 10) + parseInt(getStyle.getPropertyValue('padding-bottom'), 10)
          });
        }
      }
    });

    _defineProperty(_assertThisInitialized(_this2), "componentDidUpdate", function (prevProps) {
      if (prevProps.expanded !== _this2.props.expanded) {
        _this2.setMaxHeight();
      }
    });

    _defineProperty(_assertThisInitialized(_this2), "setMaxHeight", function () {
      if (_this2.state.expanded ? _this2.tileContent : _this2.aboveTheFold) {
        _this2.setState({
          tileMaxHeight: _this2.state.expanded ? _this2.tileContent.getBoundingClientRect().height : _this2.aboveTheFold.getBoundingClientRect().height
        });
      }
    });

    _defineProperty(_assertThisInitialized(_this2), "handleClick", function (evt) {
      if (!_this2.props.onBeforeClick(evt) || evt.target.tagName === 'INPUT') {
        return;
      }

      evt.persist();

      _this2.setState({
        expanded: !_this2.state.expanded
      }, function () {
        _this2.setMaxHeight();

        _this2.props.handleClick(evt);
      });
    });

    _defineProperty(_assertThisInitialized(_this2), "handleKeyUp", function (evt) {
      if (evt.target !== _this2.tile) {
        if (matches(evt, [keys.Enter, keys.Space])) {
          evt.preventDefault();
        }
      }
    });

    _defineProperty(_assertThisInitialized(_this2), "getChildren", function () {
      return React.Children.toArray(_this2.props.children);
    });

    return _this2;
  }

  _createClass(ExpandableTile, [{
    key: "render",
    value: function render() {
      var _classNames5,
          _this3 = this;

      var _this$props3 = this.props,
          tabIndex = _this$props3.tabIndex,
          className = _this$props3.className,
          expanded = _this$props3.expanded,
          tileMaxHeight = _this$props3.tileMaxHeight,
          tilePadding = _this$props3.tilePadding,
          handleClick = _this$props3.handleClick,
          onClick = _this$props3.onClick,
          onKeyUp = _this$props3.onKeyUp,
          tileCollapsedIconText = _this$props3.tileCollapsedIconText,
          tileExpandedIconText = _this$props3.tileExpandedIconText,
          tileCollapsedLabel = _this$props3.tileCollapsedLabel,
          tileExpandedLabel = _this$props3.tileExpandedLabel,
          onBeforeClick = _this$props3.onBeforeClick,
          light = _this$props3.light,
          other = _objectWithoutProperties(_this$props3, _excluded4);

      var isExpanded = this.state.expanded;
      var classes = classNames("".concat(prefix, "--tile"), "".concat(prefix, "--tile--expandable"), (_classNames5 = {}, _defineProperty(_classNames5, "".concat(prefix, "--tile--is-expanded"), isExpanded), _defineProperty(_classNames5, "".concat(prefix, "--tile--light"), light), _classNames5), className);
      var tileStyle = {
        maxHeight: isExpanded ? null : this.state.tileMaxHeight + this.state.tilePadding
      };
      var childrenAsArray = this.getChildren();
      return (
        /*#__PURE__*/
        // eslint-disable-next-line jsx-a11y/click-events-have-key-events,jsx-a11y/no-static-element-interactions
        React.createElement("button", _extends({
          type: "button",
          ref: function ref(tile) {
            _this3.tile = tile;
          },
          style: tileStyle,
          className: classes,
          "aria-expanded": isExpanded,
          title: isExpanded ? tileExpandedIconText : tileCollapsedIconText
        }, other, {
          onKeyUp: composeEventHandlers([onKeyUp, this.handleKeyUp]),
          onClick: composeEventHandlers([onClick, this.handleClick]),
          tabIndex: tabIndex
        }), /*#__PURE__*/React.createElement("div", {
          ref: function ref(tileContent) {
            _this3.tileContent = tileContent;
          }
        }, /*#__PURE__*/React.createElement("div", {
          ref: function ref(aboveTheFold) {
            _this3.aboveTheFold = aboveTheFold;
          },
          className: "".concat(prefix, "--tile-content")
        }, childrenAsArray[0]), /*#__PURE__*/React.createElement("div", {
          className: "".concat(prefix, "--tile__chevron")
        }, /*#__PURE__*/React.createElement("span", null, isExpanded ? tileExpandedLabel : tileCollapsedLabel), /*#__PURE__*/React.createElement(ChevronDown16, null)), /*#__PURE__*/React.createElement("div", {
          className: "".concat(prefix, "--tile-content")
        }, childrenAsArray[1])))
      );
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps( // eslint-disable-next-line react/prop-types
    _ref2, state) {
      var expanded = _ref2.expanded,
          tileMaxHeight = _ref2.tileMaxHeight,
          tilePadding = _ref2.tilePadding;
      var prevExpanded = state.prevExpanded,
          prevTileMaxHeight = state.prevTileMaxHeight,
          prevTilePadding = state.prevTilePadding,
          currentExpanded = state.expanded,
          currentTileMaxHeight = state.tileMaxHeight,
          currentTilePadding = state.tilePadding;
      var expandedChanged = prevExpanded !== expanded;
      var tileMaxHeightChanged = prevTileMaxHeight !== tileMaxHeight;
      var tilePaddingChanged = prevTilePadding !== tilePadding;
      return !expandedChanged && !tileMaxHeightChanged && !tilePaddingChanged ? null : {
        expanded: !expandedChanged ? currentExpanded : expanded,
        tileMaxHeight: !tileMaxHeightChanged ? currentTileMaxHeight : tileMaxHeight,
        tilePadding: !tilePaddingChanged ? currentTilePadding : tilePadding,
        prevExpanded: expanded,
        prevTileMaxHeight: tileMaxHeight,
        prevTilePadding: tilePadding
      };
    }
  }]);

  return ExpandableTile;
}(Component);

_defineProperty(ExpandableTile, "propTypes", {
  /**
   * The child nodes.
   */
  children: PropTypes.node,

  /**
   * The CSS class names.
   */
  className: PropTypes.string,

  /**
   * `true` if the tile is expanded.
   */
  expanded: PropTypes.bool,

  /**
   * Specify the function to run when the ExpandableTile is clicked
   */
  handleClick: PropTypes.func,

  /**
   * An ID that can be provided to aria-labelledby
   */
  id: PropTypes.string,

  /**
   * `true` to use the light version. For use on $ui-01 backgrounds only.
   * Don't use this to make tile background color same as container background color.
   */
  light: PropTypes.bool,

  /**
   * optional handler to decide whether to ignore a click. returns false if click should be ignored
   */
  onBeforeClick: PropTypes.func,

  /**
   * optional handler to trigger a function the Tile is clicked
   */
  onClick: PropTypes.func,

  /**
   * optional handler to trigger a function when a key is pressed
   */
  onKeyUp: PropTypes.func,

  /**
   * The `tabindex` attribute.
   */
  tabIndex: PropTypes.number,

  /**
   * The description of the "collapsed" icon that can be read by screen readers.
   */
  tileCollapsedIconText: PropTypes.string,

  /**
   * When "collapsed", a label to appear next to the chevron (e.g., "View more").
   */
  tileCollapsedLabel: PropTypes.string,

  /**
   * The description of the "expanded" icon that can be read by screen readers.
   */
  tileExpandedIconText: PropTypes.string,

  /**
   * When "expanded", a label to appear next to the chevron (e.g., "View less").
   */
  tileExpandedLabel: PropTypes.string
});

_defineProperty(ExpandableTile, "defaultProps", {
  tabIndex: 0,
  expanded: false,
  tileMaxHeight: 0,
  tilePadding: 0,
  onBeforeClick: function onBeforeClick() {
    return true;
  },
  handleClick: function handleClick() {},
  tileCollapsedIconText: 'Interact to expand Tile',
  tileExpandedIconText: 'Interact to collapse Tile',
  light: false
});

export var TileAboveTheFoldContent = /*#__PURE__*/function (_Component4) {
  _inherits(TileAboveTheFoldContent, _Component4);

  var _super4 = _createSuper(TileAboveTheFoldContent);

  function TileAboveTheFoldContent() {
    _classCallCheck(this, TileAboveTheFoldContent);

    return _super4.apply(this, arguments);
  }

  _createClass(TileAboveTheFoldContent, [{
    key: "render",
    value: function render() {
      var children = this.props.children;
      return /*#__PURE__*/React.createElement("span", {
        className: "".concat(prefix, "--tile-content__above-the-fold")
      }, children);
    }
  }]);

  return TileAboveTheFoldContent;
}(Component);

_defineProperty(TileAboveTheFoldContent, "propTypes", {
  /**
   * The child nodes.
   */
  children: PropTypes.node
});

export var TileBelowTheFoldContent = /*#__PURE__*/function (_Component5) {
  _inherits(TileBelowTheFoldContent, _Component5);

  var _super5 = _createSuper(TileBelowTheFoldContent);

  function TileBelowTheFoldContent() {
    _classCallCheck(this, TileBelowTheFoldContent);

    return _super5.apply(this, arguments);
  }

  _createClass(TileBelowTheFoldContent, [{
    key: "render",
    value: function render() {
      var children = this.props.children;
      return /*#__PURE__*/React.createElement("span", {
        className: "".concat(prefix, "--tile-content__below-the-fold")
      }, children);
    }
  }]);

  return TileBelowTheFoldContent;
}(Component);

_defineProperty(TileBelowTheFoldContent, "propTypes", {
  /**
   * The child nodes.
   */
  children: PropTypes.node
});