var _excluded = ["children", "className", "href", "tabIndex"];

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { settings } from 'carbon-components';
import cx from 'classnames';
import React from 'react';
import PropTypes from 'prop-types';
var prefix = settings.prefix;

var SkipToContent = function SkipToContent(_ref) {
  var children = _ref.children,
      customClassName = _ref.className,
      href = _ref.href,
      tabIndex = _ref.tabIndex,
      rest = _objectWithoutProperties(_ref, _excluded);

  var className = cx("".concat(prefix, "--skip-to-content"), customClassName);
  return /*#__PURE__*/React.createElement("a", _extends({}, rest, {
    className: className,
    href: href,
    tabIndex: tabIndex
  }), children);
};

SkipToContent.propTypes = {
  /**
   * Provide text to display in the SkipToContent `a` tag
   */
  children: PropTypes.string.isRequired,
  className: PropTypes.string,

  /**
   * Provide the `href` to the id of the element on your package that is the
   * main content.
   */
  href: PropTypes.string.isRequired,

  /**
   * Optionally override the default tabindex of 0
   */
  tabIndex: PropTypes.string
};
SkipToContent.defaultProps = {
  children: 'Skip to main content',
  href: '#main-content',
  tabIndex: '0'
};
export default SkipToContent;