"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _iconsReact = require("@carbon/icons-react");

var _carbonComponents = require("carbon-components");

var _SkeletonText = _interopRequireDefault(require("../SkeletonText"));

var _deprecate = _interopRequireDefault(require("../../prop-types/deprecate"));

var _excluded = ["align", "open", "count", "className"];

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var prefix = _carbonComponents.settings.prefix;

function AccordionSkeleton(_ref) {
  var align = _ref.align,
      open = _ref.open,
      count = _ref.count,
      className = _ref.className,
      rest = _objectWithoutProperties(_ref, _excluded);

  var classes = (0, _classnames.default)("".concat(prefix, "--accordion"), "".concat(prefix, "--skeleton"), className, _defineProperty({}, "".concat(prefix, "--accordion--").concat(align), align));
  var numSkeletonItems = open ? count - 1 : count;
  return /*#__PURE__*/_react.default.createElement("ul", _extends({
    className: classes
  }, rest), open && /*#__PURE__*/_react.default.createElement("li", {
    className: "".concat(prefix, "--accordion__item ").concat(prefix, "--accordion__item--active")
  }, /*#__PURE__*/_react.default.createElement("span", {
    className: "".concat(prefix, "--accordion__heading")
  }, /*#__PURE__*/_react.default.createElement(_iconsReact.ChevronRight16, {
    className: "".concat(prefix, "--accordion__arrow")
  }), /*#__PURE__*/_react.default.createElement(_SkeletonText.default, {
    className: "".concat(prefix, "--accordion__title")
  })), /*#__PURE__*/_react.default.createElement("div", {
    className: "".concat(prefix, "--accordion__content")
  }, /*#__PURE__*/_react.default.createElement(_SkeletonText.default, {
    width: "90%"
  }), /*#__PURE__*/_react.default.createElement(_SkeletonText.default, {
    width: "80%"
  }), /*#__PURE__*/_react.default.createElement(_SkeletonText.default, {
    width: "95%"
  }))), Array.from({
    length: numSkeletonItems
  }).map(function (_, i) {
    return /*#__PURE__*/_react.default.createElement(AccordionSkeletonItem, {
      key: i
    });
  }));
}

AccordionSkeleton.propTypes = {
  /**
   * Specify the alignment of the accordion heading title and chevron.
   */
  align: _propTypes.default.oneOf(['start', 'end']),

  /**
   * Specify an optional className to add.
   */
  className: _propTypes.default.string,

  /**
   * Set number of items to render
   */
  count: _propTypes.default.number,

  /**
   * `false` to not display the first item opened
   */
  open: _propTypes.default.bool,

  /**
   * Set unique identifier to generate unique item keys
   */
  uid: (0, _deprecate.default)(_propTypes.default.any)
};
AccordionSkeleton.defaultProps = {
  open: true,
  count: 4,
  align: 'end'
};

function AccordionSkeletonItem() {
  return /*#__PURE__*/_react.default.createElement("li", {
    className: "".concat(prefix, "--accordion__item")
  }, /*#__PURE__*/_react.default.createElement("span", {
    className: "".concat(prefix, "--accordion__heading")
  }, /*#__PURE__*/_react.default.createElement(_iconsReact.ChevronRight16, {
    className: "".concat(prefix, "--accordion__arrow")
  }), /*#__PURE__*/_react.default.createElement(_SkeletonText.default, {
    className: "".concat(prefix, "--accordion__title")
  })));
}

var _default = AccordionSkeleton;
exports.default = _default;