"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = require("react");

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr == null ? null : typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]; if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * @param {Element|Document|Window} [trigger=document] The element which should trigger the Menu on right-click
 * @returns {object} Props object to pass onto Menu component
 */
function useContextMenu() {
  var trigger = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : document;

  var _useState = (0, _react.useState)(false),
      _useState2 = _slicedToArray(_useState, 2),
      open = _useState2[0],
      setOpen = _useState2[1];

  var _useState3 = (0, _react.useState)(false),
      _useState4 = _slicedToArray(_useState3, 2),
      canBeClosed = _useState4[0],
      setCanBeClosed = _useState4[1];

  var _useState5 = (0, _react.useState)([0, 0]),
      _useState6 = _slicedToArray(_useState5, 2),
      position = _useState6[0],
      setPosition = _useState6[1];

  function openContextMenu(e) {
    e.preventDefault();
    var x = e.x,
        y = e.y;
    setPosition([x, y]);
    setOpen(true); // Safari emits the click event when preventDefault was called on
    // the contextmenu event. This is registered by the ClickListener
    // component and would lead to immediate closing when a user is
    // triggering the menu with ctrl+click. To prevent this, we only
    // allow the menu to be closed after the click event was received.
    // Since other browsers don't emit this event, it's also reset with
    // a 50ms delay after mouseup event was called.

    document.addEventListener('mouseup', function () {
      setTimeout(function () {
        setCanBeClosed(true);
      }, 50);
    }, {
      once: true
    });
    document.addEventListener('click', function () {
      setCanBeClosed(true);
    }, {
      once: true
    });
  }

  function onClose() {
    setOpen(false);
  }

  (0, _react.useEffect)(function () {
    if (trigger && trigger instanceof Element || trigger instanceof Document || trigger instanceof Window) {
      trigger.addEventListener('contextmenu', openContextMenu);
      return function () {
        trigger.removeEventListener('contextmenu', openContextMenu);
      };
    }
  }, [trigger]);
  return {
    open: open,
    x: position[0],
    y: position[1],
    autoclose: canBeClosed,
    onClose: onClose
  };
}

var _default = useContextMenu;
exports.default = _default;