"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _classnames = _interopRequireDefault(require("classnames"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _carbonComponents = require("carbon-components");

var _Button = _interopRequireDefault(require("../Button"));

var _TableActionList = _interopRequireDefault(require("./TableActionList"));

var _excluded = ["className", "children", "shouldShowBatchActions", "totalSelected", "onCancel", "translateWithId"];

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var prefix = _carbonComponents.settings.prefix;
var translationKeys = {
  'carbon.table.batch.cancel': 'Cancel',
  'carbon.table.batch.items.selected': 'items selected',
  'carbon.table.batch.item.selected': 'item selected'
};

var translateWithId = function translateWithId(id, state) {
  if (id === 'carbon.table.batch.cancel') {
    return translationKeys[id];
  }

  return "".concat(state.totalSelected, " ").concat(translationKeys[id]);
};

var TableBatchActions = function TableBatchActions(_ref) {
  var _cx;

  var className = _ref.className,
      children = _ref.children,
      shouldShowBatchActions = _ref.shouldShowBatchActions,
      totalSelected = _ref.totalSelected,
      onCancel = _ref.onCancel,
      t = _ref.translateWithId,
      rest = _objectWithoutProperties(_ref, _excluded);

  var batchActionsClasses = (0, _classnames.default)((_cx = {}, _defineProperty(_cx, "".concat(prefix, "--batch-actions"), true), _defineProperty(_cx, "".concat(prefix, "--batch-actions--active"), shouldShowBatchActions), _cx), className);
  return /*#__PURE__*/_react.default.createElement("div", _extends({}, rest, {
    "aria-hidden": !shouldShowBatchActions,
    className: batchActionsClasses
  }), /*#__PURE__*/_react.default.createElement("div", {
    className: "".concat(prefix, "--batch-summary")
  }, /*#__PURE__*/_react.default.createElement("p", {
    className: "".concat(prefix, "--batch-summary__para")
  }, /*#__PURE__*/_react.default.createElement("span", null, totalSelected > 1 || totalSelected === 0 ? t('carbon.table.batch.items.selected', {
    totalSelected: totalSelected
  }) : t('carbon.table.batch.item.selected', {
    totalSelected: totalSelected
  })))), /*#__PURE__*/_react.default.createElement(_TableActionList.default, null, children, /*#__PURE__*/_react.default.createElement(_Button.default, {
    className: "".concat(prefix, "--batch-summary__cancel"),
    tabIndex: shouldShowBatchActions ? 0 : -1,
    onClick: onCancel
  }, t('carbon.table.batch.cancel'))));
};

TableBatchActions.translationKeys = Object.keys(translationKeys);
TableBatchActions.propTypes = {
  children: _propTypes.default.node,
  className: _propTypes.default.string,

  /**
   * Hook required to listen for when the user initiates a cancel request
   * through this component
   */
  onCancel: _propTypes.default.func.isRequired,

  /**
   * Boolean specifier for whether or not the batch action bar should be
   * displayed
   */
  shouldShowBatchActions: _propTypes.default.bool,

  /**
   * Numeric representation of the total number of items selected in a table.
   * This number is used to derive the selection message
   */
  totalSelected: _propTypes.default.number.isRequired,

  /**
   * Supply a method to translate internal strings with your i18n tool of
   * choice. Translation keys are available on the `translationKeys` field for
   * this component.
   */
  translateWithId: _propTypes.default.func
};
TableBatchActions.defaultProps = {
  translateWithId: translateWithId
};
var _default = TableBatchActions;
exports.default = _default;