"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _carbonComponents = require("carbon-components");

var _classnames = _interopRequireDefault(require("classnames"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _Filename = _interopRequireDefault(require("./Filename"));

var _FileUploaderButton = _interopRequireDefault(require("./FileUploaderButton"));

var _types = require("../../prop-types/types");

var _keyboard = require("../../internal/keyboard");

var _excluded = ["iconDescription", "buttonLabel", "buttonKind", "filenameStatus", "labelDescription", "labelTitle", "className", "multiple", "accept", "name", "size", "onDelete"];

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var prefix = _carbonComponents.settings.prefix;

var FileUploader = /*#__PURE__*/function (_React$Component) {
  _inherits(FileUploader, _React$Component);

  var _super = _createSuper(FileUploader);

  function FileUploader() {
    var _this;

    _classCallCheck(this, FileUploader);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    _defineProperty(_assertThisInitialized(_this), "state", {
      filenames: []
    });

    _defineProperty(_assertThisInitialized(_this), "nodes", []);

    _defineProperty(_assertThisInitialized(_this), "handleChange", function (evt) {
      evt.stopPropagation();
      var filenames = Array.prototype.map.call(evt.target.files, function (file) {
        return file.name;
      });

      _this.setState({
        filenames: _this.props.multiple ? _this.state.filenames.concat(filenames) : filenames
      });

      if (_this.props.onChange) {
        _this.props.onChange(evt);
      }
    });

    _defineProperty(_assertThisInitialized(_this), "handleClick", function (evt, _ref) {
      var index = _ref.index,
          filenameStatus = _ref.filenameStatus;

      if (filenameStatus === 'edit') {
        evt.stopPropagation();

        var filteredArray = _this.state.filenames.filter(function (filename) {
          return filename !== _this.nodes[index].innerText.trim();
        });

        _this.setState({
          filenames: filteredArray
        });

        if (_this.props.onDelete) {
          _this.props.onDelete(evt);
        }

        _this.props.onClick(evt);
      }
    });

    _defineProperty(_assertThisInitialized(_this), "clearFiles", function () {
      // A clearFiles function that resets filenames and can be referenced using a ref by the parent.
      _this.setState({
        filenames: []
      });
    });

    return _this;
  }

  _createClass(FileUploader, [{
    key: "render",
    value: function render() {
      var _classNames,
          _classNames2,
          _this2 = this;

      var _this$props = this.props,
          iconDescription = _this$props.iconDescription,
          buttonLabel = _this$props.buttonLabel,
          buttonKind = _this$props.buttonKind,
          filenameStatus = _this$props.filenameStatus,
          labelDescription = _this$props.labelDescription,
          labelTitle = _this$props.labelTitle,
          className = _this$props.className,
          multiple = _this$props.multiple,
          accept = _this$props.accept,
          name = _this$props.name,
          size = _this$props.size,
          onDelete = _this$props.onDelete,
          other = _objectWithoutProperties(_this$props, _excluded);

      var classes = (0, _classnames.default)((_classNames = {}, _defineProperty(_classNames, "".concat(prefix, "--form-item"), true), _defineProperty(_classNames, className, className), _classNames));
      var selectedFileClasses = (0, _classnames.default)("".concat(prefix, "--file__selected-file"), (_classNames2 = {}, _defineProperty(_classNames2, "".concat(prefix, "--file__selected-file--md"), size === 'field' || size === 'md'), _defineProperty(_classNames2, "".concat(prefix, "--file__selected-file--sm"), size === 'small' || size === 'sm'), _classNames2));
      return /*#__PURE__*/_react.default.createElement("div", _extends({
        className: classes
      }, other), /*#__PURE__*/_react.default.createElement("p", {
        className: "".concat(prefix, "--file--label")
      }, labelTitle), /*#__PURE__*/_react.default.createElement("p", {
        className: "".concat(prefix, "--label-description")
      }, labelDescription), /*#__PURE__*/_react.default.createElement(_FileUploaderButton.default, {
        labelText: buttonLabel,
        multiple: multiple,
        buttonKind: buttonKind,
        onChange: this.handleChange,
        disableLabelChanges: true,
        accept: accept,
        name: name,
        size: size
      }), /*#__PURE__*/_react.default.createElement("div", {
        className: "".concat(prefix, "--file-container")
      }, this.state.filenames.length === 0 ? null : this.state.filenames.map(function (name, index) {
        return /*#__PURE__*/_react.default.createElement("span", _extends({
          key: index,
          className: selectedFileClasses,
          ref: function ref(node) {
            return _this2.nodes[index] = node;
          } // eslint-disable-line

        }, other), /*#__PURE__*/_react.default.createElement("p", {
          className: "".concat(prefix, "--file-filename")
        }, name), /*#__PURE__*/_react.default.createElement("span", {
          className: "".concat(prefix, "--file__state-container")
        }, /*#__PURE__*/_react.default.createElement(_Filename.default, {
          iconDescription: iconDescription,
          status: filenameStatus,
          onKeyDown: function onKeyDown(evt) {
            if ((0, _keyboard.matches)(evt, [_keyboard.keys.Enter, _keyboard.keys.Space])) {
              _this2.handleClick(evt, {
                index: index,
                filenameStatus: filenameStatus
              });
            }
          },
          onClick: function onClick(evt) {
            return _this2.handleClick(evt, {
              index: index,
              filenameStatus: filenameStatus
            });
          }
        })));
      })));
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(_ref2, state) {
      var filenameStatus = _ref2.filenameStatus;
      var prevFilenameStatus = state.prevFilenameStatus;
      return prevFilenameStatus === filenameStatus ? null : {
        filenameStatus: filenameStatus,
        prevFilenameStatus: filenameStatus
      };
    }
  }]);

  return FileUploader;
}(_react.default.Component);

exports.default = FileUploader;

_defineProperty(FileUploader, "propTypes", {
  /**
   * Specify the types of files that this input should be able to receive
   */
  accept: _propTypes.default.arrayOf(_propTypes.default.string),

  /**
   * Specify the type of the <FileUploaderButton>
   */
  buttonKind: _propTypes.default.oneOf(_types.ButtonKinds),

  /**
   * Provide the label text to be read by screen readers when interacting with
   * the <FileUploaderButton>
   */
  buttonLabel: _propTypes.default.string,

  /**
   * Provide a custom className to be applied to the container node
   */
  className: _propTypes.default.string,

  /**
   * Specify the status of the File Upload
   */
  filenameStatus: _propTypes.default.oneOf(['edit', 'complete', 'uploading']).isRequired,

  /**
   * Provide a description for the complete/close icon that can be read by screen readers
   */
  iconDescription: _propTypes.default.string,

  /**
   * Specify the description text of this <FileUploader>
   */
  labelDescription: _propTypes.default.string,

  /**
   * Specify the title text of this <FileUploader>
   */
  labelTitle: _propTypes.default.string,

  /**
   * Specify if the component should accept multiple files to upload
   */
  multiple: _propTypes.default.bool,

  /**
   * Provide a name for the underlying `<input>` node
   */
  name: _propTypes.default.string,

  /**
   * Provide an optional `onChange` hook that is called each time the input is
   * changed
   */
  onChange: _propTypes.default.func,

  /**
   * Provide an optional `onClick` hook that is called each time the
   * FileUploader is clicked
   */
  onClick: _propTypes.default.func,

  /**
   * Provide an optional `onDelete` hook that is called when an uploaded item
   * is removed
   */
  onDelete: _propTypes.default.func,

  /**
   * Specify the size of the FileUploaderButton, from a list of available
   * sizes. For `default` buttons, this prop can remain unspecified.
   * V11: `default`, `field`, and `small` will be removed
   */
  size: _propTypes.default.oneOf(['default', 'field', 'small', 'sm', 'md', 'lg'])
});

_defineProperty(FileUploader, "defaultProps", {
  iconDescription: 'Provide icon description',
  filenameStatus: 'uploading',
  buttonLabel: '',
  buttonKind: 'primary',
  multiple: false,
  onClick: function onClick() {},
  accept: []
});