"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _carbonComponents = require("carbon-components");

var _classnames = _interopRequireDefault(require("classnames"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireWildcard(require("react"));

var _FeatureFlags = require("../FeatureFlags");

var _excluded = ["as", "condensed", "narrow", "fullWidth", "columns", "className", "children"];

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var prefix = _carbonComponents.settings.prefix;

var SubgridContext = /*#__PURE__*/_react.default.createContext(false);

function Grid(_ref) {
  var _cssGridClassNames, _flexGridClassNames;

  var _ref$as = _ref.as,
      BaseComponent = _ref$as === void 0 ? 'div' : _ref$as,
      _ref$condensed = _ref.condensed,
      condensed = _ref$condensed === void 0 ? false : _ref$condensed,
      _ref$narrow = _ref.narrow,
      narrow = _ref$narrow === void 0 ? false : _ref$narrow,
      _ref$fullWidth = _ref.fullWidth,
      fullWidth = _ref$fullWidth === void 0 ? false : _ref$fullWidth,
      _ref$columns = _ref.columns,
      columns = _ref$columns === void 0 ? 16 : _ref$columns,
      containerClassName = _ref.className,
      children = _ref.children,
      rest = _objectWithoutProperties(_ref, _excluded);

  var hasCSSGrid = (0, _FeatureFlags.useFeatureFlag)('enable-css-grid');
  var isSubgrid = (0, _react.useContext)(SubgridContext);
  var cssGridClassNames = (_cssGridClassNames = {}, _defineProperty(_cssGridClassNames, "".concat(prefix, "--css-grid"), !isSubgrid), _defineProperty(_cssGridClassNames, "".concat(prefix, "--css-grid--").concat(columns), !isSubgrid && columns !== 16), _defineProperty(_cssGridClassNames, "".concat(prefix, "--css-grid--condensed"), condensed), _defineProperty(_cssGridClassNames, "".concat(prefix, "--css-grid--narrow"), narrow), _defineProperty(_cssGridClassNames, "".concat(prefix, "--css-grid--full-width"), fullWidth), _defineProperty(_cssGridClassNames, "".concat(prefix, "--subgrid"), isSubgrid), _defineProperty(_cssGridClassNames, "".concat(prefix, "--col-span-").concat(columns), isSubgrid && columns !== 16 || columns !== 16), _cssGridClassNames);
  var flexGridClassNames = (_flexGridClassNames = {}, _defineProperty(_flexGridClassNames, "".concat(prefix, "--grid"), true), _defineProperty(_flexGridClassNames, "".concat(prefix, "--grid--condensed"), condensed), _defineProperty(_flexGridClassNames, "".concat(prefix, "--grid--narrow"), narrow), _defineProperty(_flexGridClassNames, "".concat(prefix, "--grid--full-width"), fullWidth), _flexGridClassNames);
  var className = (0, _classnames.default)(containerClassName, hasCSSGrid ? cssGridClassNames : flexGridClassNames);
  return /*#__PURE__*/_react.default.createElement(SubgridContext.Provider, {
    value: true
  }, /*#__PURE__*/_react.default.createElement(BaseComponent, _extends({
    className: className
  }, rest), children));
}

Grid.propTypes = {
  /**
   * Provide a custom element to render instead of the default <div>
   */
  as: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.elementType]),

  /**
   * Pass in content that will be rendered within the `Grid`
   */
  children: _propTypes.default.node,

  /**
   * Specify a custom className to be applied to the `Grid`
   */
  className: _propTypes.default.string,

  /**
   * Specify how many columns wide the Grid should span
   */
  columns: _propTypes.default.number,

  /**
   * Collapse the gutter to 1px. Useful for fluid layouts.
   * Rows have 1px of margin between them to match gutter.
   */
  condensed: _propTypes.default.bool,

  /**
   * Remove the default max width that the grid has set
   */
  fullWidth: _propTypes.default.bool,

  /**
   * Container hangs 16px into the gutter. Useful for
   * typographic alignment with and without containers.
   */
  narrow: _propTypes.default.bool
};
var _default = Grid;
exports.default = _default;