"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _MenuOption = _interopRequireDefault(require("./MenuOption"));

var _excluded = ["label", "children", "disabled", "kind", "shortcut"];

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function MenuItem(_ref) {
  var label = _ref.label,
      children = _ref.children,
      disabled = _ref.disabled,
      kind = _ref.kind,
      shortcut = _ref.shortcut,
      rest = _objectWithoutProperties(_ref, _excluded);

  return /*#__PURE__*/_react.default.createElement(_MenuOption.default, _extends({}, rest, {
    label: label,
    disabled: disabled,
    kind: kind,
    shortcut: shortcut
  }), children);
}

MenuItem.propTypes = {
  /**
   * Specify the children of the MenuItem
   */
  children: _propTypes.default.node,

  /**
   * Specify whether this MenuItem is disabled
   */
  disabled: _propTypes.default.bool,

  /**
   * Optional prop to specify the kind of the MenuItem
   */
  kind: _propTypes.default.oneOf(['default', 'danger']),

  /**
   * Rendered label for the MenuItem
   */
  label: _propTypes.default.node.isRequired,

  /**
   * Rendered shortcut for the MenuItem
   */
  shortcut: _propTypes.default.node
};
var _default = MenuItem;
exports.default = _default;