"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.NumberInput = exports.translationIds = void 0;

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireWildcard(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _carbonComponents = require("carbon-components");

var _iconsReact = require("@carbon/icons-react");

var _mergeRefs = _interopRequireDefault(require("../../tools/mergeRefs"));

var _requiredIfValueExists = _interopRequireDefault(require("../../prop-types/requiredIfValueExists"));

var _useNormalizedInputProps = require("../../internal/useNormalizedInputProps");

var _FeatureFlags = require("../../internal/FeatureFlags");

var _deprecate = _interopRequireDefault(require("../../prop-types/deprecate"));

var _excluded = ["className", "disabled", "iconDescription", "id", "hideLabel", "hideSteppers", "label", "max", "min", "step", "value", "readOnly", "invalid", "invalidText", "warn", "warnText", "helperText", "ariaLabel", "light", "allowEmpty", "innerRef", "translateWithId", "isMobile", "size", "defaultValue"];

var _defaultTranslations;

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var prefix = _carbonComponents.settings.prefix;
var translationIds = {
  'increment.number': 'increment.number',
  'decrement.number': 'decrement.number'
};
exports.translationIds = translationIds;
var defaultTranslations = (_defaultTranslations = {}, _defineProperty(_defaultTranslations, translationIds['increment.number'], 'Increment number'), _defineProperty(_defaultTranslations, translationIds['decrement.number'], 'Decrement number'), _defaultTranslations);

var capMin = function capMin(min, value) {
  return isNaN(min) || !min && min !== 0 || isNaN(value) || !value && value !== 0 ? value : Math.max(min, value);
};

var capMax = function capMax(max, value) {
  return isNaN(max) || !max && max !== 0 || isNaN(value) || !value && value !== 0 ? value : Math.min(max, value);
};

var NumberInput = /*#__PURE__*/function (_Component) {
  _inherits(NumberInput, _Component);

  var _super = _createSuper(NumberInput);

  function NumberInput(props) {
    var _this;

    _classCallCheck(this, NumberInput);

    _this = _super.call(this, props);

    _defineProperty(_assertThisInitialized(_this), "_inputRef", null);

    _defineProperty(_assertThisInitialized(_this), "handleChange", function (evt) {
      var _this$props = _this.props,
          disabled = _this$props.disabled,
          onChange = _this$props.onChange;

      if (!disabled) {
        evt.persist();
        evt.imaginaryTarget = _this._inputRef;
        var prevValue = _this.state.value;
        var value = evt.target.value;
        var direction = prevValue < value ? 'up' : 'down';

        _this.setState({
          value: value
        }, function () {
          if (_FeatureFlags.useControlledStateWithValue) {
            onChange(evt, {
              value: value,
              direction: direction
            });
          } else if (onChange) {
            onChange(evt, {
              value: value,
              direction: direction
            });
          }
        });
      }
    });

    _defineProperty(_assertThisInitialized(_this), "handleArrowClick", function (evt, direction) {
      var value = typeof _this.state.value === 'string' ? Number(_this.state.value) : _this.state.value;
      var _this$props2 = _this.props,
          disabled = _this$props2.disabled,
          min = _this$props2.min,
          max = _this$props2.max,
          step = _this$props2.step,
          onChange = _this$props2.onChange,
          onClick = _this$props2.onClick;
      var conditional = direction === 'down' ? min !== undefined && value > min || min === undefined : max !== undefined && value < max || max === undefined;

      if (!disabled && conditional) {
        value = direction === 'down' ? value - step : value + step;
        value = capMax(max, capMin(min, value));
        evt.persist();
        evt.imaginaryTarget = _this._inputRef;

        _this.setState({
          value: value
        }, function () {
          //TO-DO v11: update these events to return the same things --> evt, {value, direction}
          if (_FeatureFlags.useControlledStateWithValue) {
            onClick && onClick(evt, {
              value: value,
              direction: direction
            });
            onChange && onChange(evt, {
              value: value,
              direction: direction
            });
          } else {
            // value added as a 3rd argument rather than in same obj so it doesn't break in v10
            onClick && onClick(evt, direction, value);
            onChange && onChange(evt, direction, value);
          }
        });
      }
    });

    _defineProperty(_assertThisInitialized(_this), "_handleInputRef", function (ref) {
      _this._inputRef = ref;
    });

    _this.isControlled = props.value !== undefined;

    if (_FeatureFlags.useControlledStateWithValue && _this.isControlled) {
      // Skips the logic of setting initial state if this component is controlled
      _this.state = {};
      return _possibleConstructorReturn(_this);
    }

    var _value = _FeatureFlags.useControlledStateWithValue || typeof props.defaultValue !== 'undefined' ? props.defaultValue : props.value;

    _value = _value === undefined ? 0 : _value;

    if (props.min || props.min === 0) {
      _value = Math.max(props.min, _value);
    }

    _this.state = {
      value: _value
    };
    return _this;
  }

  _createClass(NumberInput, [{
    key: "render",
    value: function render() {
      var _classNames,
          _classNames3,
          _classNames5,
          _this2 = this;

      var _this$props3 = this.props,
          className = _this$props3.className,
          disabled = _this$props3.disabled,
          iconDescription = _this$props3.iconDescription,
          id = _this$props3.id,
          hideLabel = _this$props3.hideLabel,
          hideSteppers = _this$props3.hideSteppers,
          label = _this$props3.label,
          max = _this$props3.max,
          min = _this$props3.min,
          step = _this$props3.step,
          value = _this$props3.value,
          readOnly = _this$props3.readOnly,
          invalid = _this$props3.invalid,
          invalidText = _this$props3.invalidText,
          warn = _this$props3.warn,
          warnText = _this$props3.warnText,
          helperText = _this$props3.helperText,
          ariaLabel = _this$props3.ariaLabel,
          light = _this$props3.light,
          allowEmpty = _this$props3.allowEmpty,
          ref = _this$props3.innerRef,
          t = _this$props3.translateWithId,
          isMobile = _this$props3.isMobile,
          size = _this$props3.size,
          defaultValue = _this$props3.defaultValue,
          other = _objectWithoutProperties(_this$props3, _excluded);

      var numberInputClasses = (0, _classnames.default)("".concat(prefix, "--number ").concat(prefix, "--number--helpertext"), className, (_classNames = {}, _defineProperty(_classNames, "".concat(prefix, "--number--readonly"), readOnly), _defineProperty(_classNames, "".concat(prefix, "--number--light"), light), _defineProperty(_classNames, "".concat(prefix, "--number--nolabel"), hideLabel), _defineProperty(_classNames, "".concat(prefix, "--number--nosteppers"), hideSteppers), _defineProperty(_classNames, "".concat(prefix, "--number--mobile"), isMobile), _defineProperty(_classNames, "".concat(prefix, "--number--").concat(size), size), _classNames));
      var isInputInvalid; // If the user supplied `invalid` through props, we'll defer to the passed in value

      if (invalid) {
        isInputInvalid = true;
      } else {
        // Otherwise, if we don't allow an empty value then we check to see
        // if the value is empty, or if it is out of range
        if (!allowEmpty && this.state.value === '') {
          isInputInvalid = true;
        } else {
          if (this.state.value !== '' && (this.state.value > max || this.state.value < min)) {
            isInputInvalid = true;
          }
        }
      }

      var normalizedProps = (0, _useNormalizedInputProps.useNormalizedInputProps)({
        id: id,
        readOnly: readOnly,
        disabled: disabled,
        invalid: isInputInvalid,
        invalidText: invalidText,
        warn: warn,
        warnText: warnText
      });
      var props = {
        disabled: normalizedProps.disabled,
        id: id,
        max: max,
        min: min,
        step: step,
        onChange: this.handleChange,
        value: _FeatureFlags.useControlledStateWithValue && this.isControlled ? value : this.state.value,
        readOnly: readOnly,
        'aria-label': label ? null : ariaLabel
      };
      var buttonProps = {
        disabled: disabled
      };
      var inputWrapperProps = {};

      if (normalizedProps.invalid) {
        inputWrapperProps['data-invalid'] = true;
      }

      var helperTextClasses = (0, _classnames.default)("".concat(prefix, "--form__helper-text"), _defineProperty({}, "".concat(prefix, "--form__helper-text--disabled"), normalizedProps.disabled));
      var helper = helperText ? /*#__PURE__*/_react.default.createElement("div", {
        className: helperTextClasses
      }, helperText) : null;
      var labelClasses = (0, _classnames.default)("".concat(prefix, "--label"), (_classNames3 = {}, _defineProperty(_classNames3, "".concat(prefix, "--label--disabled"), normalizedProps.disabled), _defineProperty(_classNames3, "".concat(prefix, "--visually-hidden"), hideLabel), _classNames3));
      var labelText = label ? /*#__PURE__*/_react.default.createElement("label", {
        htmlFor: id,
        className: labelClasses
      }, label) : null;
      var _ref = [t('increment.number'), t('decrement.number')],
          incrementNumLabel = _ref[0],
          decrementNumLabel = _ref[1];
      var wrapperClasses = (0, _classnames.default)("".concat(prefix, "--number__input-wrapper"), _defineProperty({}, "".concat(prefix, "--number__input-wrapper--warning"), normalizedProps.warn));
      var iconClasses = (0, _classnames.default)((_classNames5 = {}, _defineProperty(_classNames5, "".concat(prefix, "--number__invalid"), normalizedProps.invalid || normalizedProps.warn), _defineProperty(_classNames5, "".concat(prefix, "--number__invalid--warning"), normalizedProps.warn), _defineProperty(_classNames5, "".concat(prefix, "--number__readonly-icon"), readOnly), _classNames5));
      var ariaDescribedBy = null;

      if (normalizedProps.invalid) {
        ariaDescribedBy = normalizedProps.invalidId;
      }

      if (normalizedProps.warn) {
        ariaDescribedBy = normalizedProps.warnId;
      }

      return /*#__PURE__*/_react.default.createElement("div", {
        className: "".concat(prefix, "--form-item")
      }, /*#__PURE__*/_react.default.createElement("div", _extends({
        className: numberInputClasses
      }, inputWrapperProps), function () {
        return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, labelText, /*#__PURE__*/_react.default.createElement("div", {
          className: wrapperClasses
        }, /*#__PURE__*/_react.default.createElement("input", _extends({
          "data-invalid": normalizedProps.invalid,
          "aria-invalid": normalizedProps.invalid,
          "aria-describedby": ariaDescribedBy,
          type: "number",
          pattern: "[0-9]*"
        }, other, props, {
          ref: (0, _mergeRefs.default)(ref, _this2._handleInputRef)
        })), normalizedProps.icon && /*#__PURE__*/_react.default.createElement(normalizedProps.icon, {
          className: iconClasses
        }), !hideSteppers && /*#__PURE__*/_react.default.createElement("div", {
          className: "".concat(prefix, "--number__controls")
        }, /*#__PURE__*/_react.default.createElement("button", _extends({
          type: "button",
          className: "".concat(prefix, "--number__control-btn down-icon")
        }, buttonProps, {
          onClick: function onClick(evt) {
            return _this2.handleArrowClick(evt, 'down');
          },
          title: decrementNumLabel || iconDescription,
          "aria-label": decrementNumLabel || iconDescription,
          tabIndex: "-1"
        }), /*#__PURE__*/_react.default.createElement(_iconsReact.Subtract16, {
          className: "down-icon"
        })), /*#__PURE__*/_react.default.createElement("div", {
          className: "".concat(prefix, "--number__rule-divider")
        }), /*#__PURE__*/_react.default.createElement("button", _extends({
          type: "button",
          className: "".concat(prefix, "--number__control-btn up-icon")
        }, buttonProps, {
          onClick: function onClick(evt) {
            return _this2.handleArrowClick(evt, 'up');
          },
          title: incrementNumLabel || iconDescription,
          "aria-label": incrementNumLabel || iconDescription,
          tabIndex: "-1"
        }), /*#__PURE__*/_react.default.createElement(_iconsReact.Add16, {
          className: "up-icon"
        })), /*#__PURE__*/_react.default.createElement("div", {
          className: "".concat(prefix, "--number__rule-divider")
        }))), normalizedProps.validation ? null : helper);
      }(), normalizedProps.validation));
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(_ref2, state) {
      var value = _ref2.value;
      var prevValue = state.prevValue;

      if (_FeatureFlags.useControlledStateWithValue && value === '' && prevValue !== '') {
        return {
          value: '',
          prevValue: ''
        };
      } // If `useControlledStateWithValue` feature flag is on, do nothing here.
      // Otherwise, do prop -> state sync with "value capping".
      //// Value capping removed in #8965
      //// value: capMax(max, capMin(min, value)), (L223)


      return _FeatureFlags.useControlledStateWithValue || prevValue === value ? null : {
        value: value,
        prevValue: value
      };
    }
    /**
     * The DOM node reference to the `<input>`.
     * @type {HTMLInputElement}
     */

  }]);

  return NumberInput;
}(_react.Component);

exports.NumberInput = NumberInput;

_defineProperty(NumberInput, "propTypes", {
  /**
   * `true` to allow empty string.
   */
  allowEmpty: _propTypes.default.bool,

  /**
   * Provide a description that would be used to best describe the use case of the NumberInput component
   */
  ariaLabel: _propTypes.default.string,

  /**
   * Specify an optional className to be applied to the wrapper node
   */
  className: _propTypes.default.string,

  /**
   * Optional starting value for uncontrolled state
   */
  defaultValue: _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string]),

  /**
   * Specify if the control should be disabled, or not
   */
  disabled: _propTypes.default.bool,

  /**
   * Provide text that is used alongside the control label for additional help
   */
  helperText: _propTypes.default.node,

  /**
   * Specify whether you want the underlying label to be visually hidden
   */
  hideLabel: _propTypes.default.bool,

  /**
   * Specify whether you want the steppers to be hidden
   */
  hideSteppers: _propTypes.default.bool,

  /**
   * Provide a description for up/down icons that can be read by screen readers
   */
  iconDescription: _propTypes.default.string.isRequired,

  /**
   * Specify a custom `id` for the input
   */
  id: _propTypes.default.string.isRequired,

  /**
   * Specify if the currently value is invalid.
   */
  invalid: _propTypes.default.bool,

  /**
   * Message which is displayed if the value is invalid.
   */
  invalidText: _propTypes.default.node,

  /**
   * `true` to use the mobile variant.
   */
  isMobile: (0, _deprecate.default)(_propTypes.default.bool, "The `isMobile` prop no longer needed as the default NumberInput styles are now identical to the mobile variant styles. This prop will be removed in the next major version of `carbon-components-react`"),

  /**
   * Generic `label` that will be used as the textual representation of what
   * this field is for
   */
  label: _propTypes.default.node,

  /**
   * `true` to use the light version.
   */
  light: _propTypes.default.bool,

  /**
   * The maximum value.
   */
  max: _propTypes.default.number,

  /**
   * The minimum value.
   */
  min: _propTypes.default.number,

  /**
   * The new value is available in 'imaginaryTarget.value'
   * i.e. to get the value: evt.imaginaryTarget.value
   *
   * * _With_ `useControlledStateWithValue` feature flag, the signature of the event handler will be altered to provide additional context in the second parameter: `onChange(event, { value, direction })` where:
   *   * `event` is the (React) raw event
   *   * `value` is the new value
   *   * `direction` tells you the button you hit is up button or down button
   * * _Without_ this feature flag the event handler has `onChange(event, direction)` signature.
   */
  onChange: !_FeatureFlags.useControlledStateWithValue ? _propTypes.default.func : (0, _requiredIfValueExists.default)(_propTypes.default.func),

  /**
   * Provide an optional function to be called when the up/down button is clicked
   */
  onClick: _propTypes.default.func,

  /**
   * Specify if the component should be read-only
   */
  readOnly: _propTypes.default.bool,

  /**
   * Specify the size of the Number Input. Currently supports either `sm`, 'md' (default) or 'lg` as an option.
   * TODO V11: remove `xl` (replaced with lg)
   */
  size: _propTypes.default.oneOf(['sm', 'md', 'lg', 'xl']),

  /**
   * Specify how much the values should increase/decrease upon clicking on up/down button
   */
  step: _propTypes.default.number,

  /**
   * Provide custom text for the component for each translation id
   */
  translateWithId: _propTypes.default.func.isRequired,

  /**
   * Specify the value of the input
   */
  value: _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string]),

  /**
   * Specify whether the control is currently in warning state
   */
  warn: _propTypes.default.bool,

  /**
   * Provide the text that is displayed when the control is in warning state
   */
  warnText: _propTypes.default.node
});

_defineProperty(NumberInput, "defaultProps", {
  disabled: false,
  hideLabel: false,
  iconDescription: 'choose a number',
  step: 1,
  invalid: false,
  invalidText: 'Provide invalidText',
  warn: false,
  warnText: '',
  ariaLabel: 'Numeric input field with increment and decrement buttons',
  helperText: '',
  light: false,
  allowEmpty: false,
  translateWithId: function translateWithId(id) {
    return defaultTranslations[id];
  }
});

var _default = function () {
  var forwardRef = function forwardRef(props, ref) {
    return /*#__PURE__*/_react.default.createElement(NumberInput, _extends({}, props, {
      innerRef: ref
    }));
  };

  forwardRef.displayName = 'NumberInput';
  return /*#__PURE__*/_react.default.forwardRef(forwardRef);
}();

exports.default = _default;