"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PaginationWithCustomPageSizesLabel = exports.MultiplePaginationComponents = exports._Pagination = exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _addonActions = require("@storybook/addon-actions");

var _addonKnobs = require("@storybook/addon-knobs");

var _Pagination2 = _interopRequireDefault(require("../Pagination"));

var _Pagination3 = _interopRequireDefault(require("./Pagination.mdx"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

var sizes = {
  'Small  (sm)': 'sm',
  'Medium (md) - default': undefined,
  'Large  (lg)': 'lg'
};

var props = function props() {
  return {
    disabled: (0, _addonKnobs.boolean)('Disable page inputs (disabled)', false),
    size: (0, _addonKnobs.select)('Size (size)', sizes, undefined) || undefined,
    page: (0, _addonKnobs.number)('The current page (page)', 1),
    totalItems: (0, _addonKnobs.number)('Total number of items (totalItems)', 103),
    pagesUnknown: (0, _addonKnobs.boolean)('Total number of items unknown (pagesUnknown)', false),
    pageInputDisabled: (0, _addonKnobs.boolean)('Disable page input (pageInputDisabled)', undefined),
    pageSizeInputDisabled: (0, _addonKnobs.boolean)('Disable page size input (pageSizeInputDisabled)', undefined),
    backwardText: (0, _addonKnobs.text)('The description for the backward icon (backwardText)', 'Previous page'),
    forwardText: (0, _addonKnobs.text)('The description for the forward icon (forwardText)', 'Next page'),
    pageSize: (0, _addonKnobs.number)('Number of items per page (pageSize)', 10),
    pageSizes: (0, _addonKnobs.array)('Choices of `pageSize` (pageSizes)', [10, 20, 30, 40, 50]),
    itemsPerPageText: (0, _addonKnobs.text)('Label for `pageSizes` select UI (itemsPerPageText)', 'Items per page:'),
    onChange: (0, _addonActions.action)('onChange')
  };
};

var _default = {
  title: 'Components/Pagination',
  decorators: [_addonKnobs.withKnobs, function (story) {
    return /*#__PURE__*/_react.default.createElement("div", {
      style: {
        maxWidth: '800px'
      }
    }, story());
  }],
  parameters: {
    component: _Pagination2.default,
    docs: {
      page: _Pagination3.default
    }
  }
};
exports.default = _default;

var _Pagination = function _Pagination() {
  return /*#__PURE__*/_react.default.createElement(_Pagination2.default, props());
};

exports._Pagination = _Pagination;
_Pagination.parameters = {
  info: {
    text: "\n            The pagination component is used to switch through multiple pages of items, when only a maximum number of items can be displayed per page. Can be used in combination with other components like DataTable.\n          "
  }
};

var MultiplePaginationComponents = function MultiplePaginationComponents() {
  return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_Pagination2.default, props()), /*#__PURE__*/_react.default.createElement(_Pagination2.default, props()));
};

exports.MultiplePaginationComponents = MultiplePaginationComponents;
MultiplePaginationComponents.storyName = 'Multiple Pagination components';
MultiplePaginationComponents.parameters = {
  info: {
    text: "Showcasing unique ids for each pagination component"
  }
};

var PaginationWithCustomPageSizesLabel = function PaginationWithCustomPageSizesLabel() {
  return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_Pagination2.default, _extends({}, props(), {
    pageSizes: [{
      text: 'Ten',
      value: 10
    }, {
      text: 'Twenty',
      value: 20
    }, {
      text: 'Thirty',
      value: 30
    }, {
      text: 'Forty',
      value: 40
    }, {
      text: 'Fifty',
      value: 50
    }]
  })));
};

exports.PaginationWithCustomPageSizesLabel = PaginationWithCustomPageSizesLabel;
PaginationWithCustomPageSizesLabel.storyName = 'Pagination with custom page sizes label';
PaginationWithCustomPageSizesLabel.parameters = {
  info: {
    text: "It is also possible to use custom label in page sizes list"
  }
};