"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireWildcard(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _iconsReact = require("@carbon/icons-react");

var _carbonComponents = require("carbon-components");

var _events = require("../../tools/events");

var _keyboard = require("../../internal/keyboard");

var _deprecate = _interopRequireDefault(require("../../prop-types/deprecate"));

var _FeatureFlags = require("../FeatureFlags");

var _excluded = ["className", "type", "id", "placeHolderText", "placeholder", "labelText", "closeButtonLabelText", "small", "size", "light", "disabled", "onChange", "onKeyDown", "renderIcon"];

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var prefix = _carbonComponents.settings.prefix;

var Search = /*#__PURE__*/function (_Component) {
  _inherits(Search, _Component);

  var _super = _createSuper(Search);

  function Search() {
    var _this;

    _classCallCheck(this, Search);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    _defineProperty(_assertThisInitialized(_this), "state", {
      hasContent: _this.props.value || _this.props.defaultValue || false,
      prevValue: _this.props.value
    });

    _defineProperty(_assertThisInitialized(_this), "clearInput", function (evt) {
      if (!_this.props.value) {
        _this.input.value = '';

        _this.props.onChange(evt);
      } else {
        var clearedEvt = Object.assign({}, evt.target, {
          target: {
            value: ''
          }
        });

        _this.props.onChange(clearedEvt);
      }

      _this.setState({
        hasContent: false
      }, function () {
        return _this.input.focus();
      });
    });

    _defineProperty(_assertThisInitialized(_this), "handleChange", function (evt) {
      _this.setState({
        hasContent: evt.target.value !== ''
      });
    });

    _defineProperty(_assertThisInitialized(_this), "handleKeyDown", function (evt) {
      if ((0, _keyboard.match)(evt, _keyboard.keys.Escape)) {
        _this.clearInput(evt);
      }
    });

    return _this;
  }

  _createClass(Search, [{
    key: "render",
    value: function render() {
      var _classNames,
          _classNames2,
          _this2 = this;

      var _this$props = this.props,
          className = _this$props.className,
          type = _this$props.type,
          _this$props$id = _this$props.id,
          id = _this$props$id === void 0 ? this._inputId = this._inputId || "search__input__id_".concat(Math.random().toString(36).substr(2)) : _this$props$id,
          placeHolderText = _this$props.placeHolderText,
          placeholder = _this$props.placeholder,
          labelText = _this$props.labelText,
          closeButtonLabelText = _this$props.closeButtonLabelText,
          small = _this$props.small,
          _this$props$size = _this$props.size,
          size = _this$props$size === void 0 ? !small ? 'xl' : 'sm' : _this$props$size,
          light = _this$props.light,
          disabled = _this$props.disabled,
          onChange = _this$props.onChange,
          onKeyDown = _this$props.onKeyDown,
          renderIcon = _this$props.renderIcon,
          other = _objectWithoutProperties(_this$props, _excluded);

      var hasContent = this.state.hasContent;
      var scope = this.context;
      var enabled;

      if (scope.enabled) {
        enabled = scope.enabled('enable-v11-release');
      }

      var searchClasses = (0, _classnames.default)((_classNames = {}, _defineProperty(_classNames, "".concat(prefix, "--search"), true), _defineProperty(_classNames, "".concat(prefix, "--search--sm"), size === 'sm'), _defineProperty(_classNames, "".concat(prefix, "--search--lg"), enabled ? size === 'md' : size === 'lg'), _defineProperty(_classNames, "".concat(prefix, "--search--xl"), enabled ? size === 'lg' : size === 'xl'), _defineProperty(_classNames, "".concat(prefix, "--search--light"), light), _defineProperty(_classNames, "".concat(prefix, "--search--disabled"), disabled), _defineProperty(_classNames, className, className), _classNames));
      var clearClasses = (0, _classnames.default)((_classNames2 = {}, _defineProperty(_classNames2, "".concat(prefix, "--search-close"), true), _defineProperty(_classNames2, "".concat(prefix, "--search-close--hidden"), !hasContent), _classNames2));
      var searchId = "".concat(id, "-search");
      var searchIcon = renderIcon ? renderIcon : /*#__PURE__*/_react.default.createElement(_iconsReact.Search16, {
        className: "".concat(prefix, "--search-magnifier-icon")
      });
      return /*#__PURE__*/_react.default.createElement("div", {
        role: "search",
        "aria-labelledby": searchId,
        className: searchClasses
      }, /*#__PURE__*/_react.default.createElement("div", {
        className: "".concat(prefix, "--search-magnifier"),
        ref: function ref(magnifier) {
          _this2.magnifier = magnifier;
        }
      }, searchIcon), /*#__PURE__*/_react.default.createElement("label", {
        id: searchId,
        htmlFor: id,
        className: "".concat(prefix, "--label")
      }, labelText), /*#__PURE__*/_react.default.createElement("input", _extends({
        role: "searchbox",
        autoComplete: "off"
      }, other, {
        type: type,
        disabled: disabled,
        className: "".concat(prefix, "--search-input"),
        id: id,
        placeholder: placeHolderText || placeholder,
        onChange: (0, _events.composeEventHandlers)([onChange, this.handleChange]),
        onKeyDown: (0, _events.composeEventHandlers)([onKeyDown, this.handleKeyDown]),
        ref: function ref(input) {
          _this2.input = input;
        }
      })), /*#__PURE__*/_react.default.createElement("button", {
        className: clearClasses,
        disabled: disabled,
        onClick: this.clearInput,
        type: "button",
        "aria-label": closeButtonLabelText
      }, /*#__PURE__*/_react.default.createElement(_iconsReact.Close16, null)));
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(_ref, state) {
      var value = _ref.value;
      var prevValue = state.prevValue;
      return prevValue === value ? null : {
        hasContent: !!value,
        prevValue: value
      };
    }
  }]);

  return Search;
}(_react.Component);

exports.default = Search;

_defineProperty(Search, "propTypes", {
  /**
   * Specify an optional className to be applied to the container node
   */
  className: _propTypes.default.string,

  /**
   * Specify a label to be read by screen readers on the "close" button
   */
  closeButtonLabelText: _propTypes.default.string,

  /**
   * Optionally provide the default value of the `<input>`
   */
  defaultValue: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.number]),

  /**
   * Specify whether the `<input>` should be disabled
   */
  disabled: _propTypes.default.bool,

  /**
   * Specify a custom `id` for the input
   */
  id: _propTypes.default.string,

  /**
   * Provide the label text for the Search icon
   */
  labelText: _propTypes.default.node.isRequired,

  /**
   * Specify light version or default version of this control
   */
  light: _propTypes.default.bool,

  /**
   * Optional callback called when the search value changes.
   */
  onChange: _propTypes.default.func,

  /**
   * Provide a handler that is invoked on the key down event for the input
   */
  onKeyDown: _propTypes.default.func,

  /**
   * Deprecated in favor of `placeholder`
   */
  placeHolderText: (0, _deprecate.default)(_propTypes.default.string, "\nThe prop `placeHolderText` for Search has been deprecated in favor of `placeholder`. Please use `placeholder` instead."),

  /**
   * Provide an optional placeholder text for the Search.
   * Note: if the label and placeholder differ,
   * VoiceOver on Mac will read both
   */
  placeholder: _propTypes.default.string,

  /**
   * Rendered icon for the Search.
   * Can be a React component class
   */
  renderIcon: _propTypes.default.oneOfType([_propTypes.default.func, _propTypes.default.object]),

  /**
   * Specify the search size
   */
  size: _propTypes.default.oneOf(['sm', 'md', 'lg', 'xl']),

  /**
   * Specify whether the Search should be a small variant
   */

  /**
   * Specify whether the load was successful
   */
  small: (0, _deprecate.default)(_propTypes.default.bool, "\nThe prop `small` for Search has been deprecated in favor of `size`. Please use `size=\"sm\"` instead."),

  /**
   * Optional prop to specify the type of the `<input>`
   */
  type: _propTypes.default.string,

  /**
   * Specify the value of the `<input>`
   */
  value: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.number])
});

_defineProperty(Search, "contextType", _FeatureFlags.FeatureFlagContext);

_defineProperty(Search, "defaultProps", {
  type: 'text',
  placeholder: '',
  closeButtonLabelText: 'Clear search input',
  onChange: function onChange() {}
});