"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _core = require("@kui-shell/core");

var _2 = require("../../..");

var _DropdownWidget = _interopRequireDefault(require("./DropdownWidget"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = void 0 && (void 0).__awaiter || function (thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function (resolve) {
      resolve(value);
    });
  }

  return new (P || (P = Promise))(function (resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }

    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }

    function step(result) {
      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
    }

    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
};

const strings = (0, _core.i18n)('plugin-client-common');

class Settings extends _react.default.PureComponent {
  constructor(props) {
    super(props);
    this.state = {
      currentTheme: undefined,
      themes: []
    };
    this.recomputeThemeList();

    _core.eventChannelUnsafe.on('/theme/change', ({
      theme
    }) => {
      this.setState({
        currentTheme: theme
      });
    });
  }

  recomputeThemeList() {
    return __awaiter(this, void 0, void 0, function* () {
      const [currentTheme, themes] = yield Promise.all([(0, _core.getPersistedThemeChoice)(), (0, _core.uiThemes)().then(_ => _.map(({
        themes
      }) => themes)).then(_core.flatten)]);
      this.setState({
        currentTheme,
        themes: themes
      });
    });
  }

  header() {
    if (!this.state.currentTheme) {
      return _react.default.createElement(_2.Loading, null);
    } else {
      return _react.default.createElement(_react.default.Fragment, null, _react.default.createElement("div", null, strings('Current Theme')), _react.default.createElement("div", null, _react.default.createElement("strong", null, this.state.currentTheme)), _react.default.createElement("div", {
        className: "sub-text even-smaller-text"
      }, this.changeTheme()));
    }
  }

  body() {
    if (!this.state.currentTheme) {
      return _react.default.createElement(_2.Loading, null);
    } else {
      return _react.default.createElement(_react.default.Fragment, null);
    }
  }
  /** @return UI for changing themes */


  changeTheme() {
    return _react.default.createElement("a", {
      href: "#",
      onClick: () => (0, _core.pexecInCurrentTab)('themes')
    }, strings('Switch theme'));
  }

  render() {
    //            aria-label="Settings"
    //            tabIndex={0}
    if (!this.state || !this.state.currentTheme) {
      return _react.default.createElement(_react.default.Fragment, null);
    }

    return _react.default.createElement(_DropdownWidget.default, {
      id: "kui--settings-widget",
      title: strings('Switch theme'),
      actions: this.state.themes.map(_ => ({
        label: _.name,
        isSelected: _.name === this.state.currentTheme,
        handler: () => (0, _core.pexecInCurrentTab)(`theme set ${(0, _core.encodeComponent)(_.name)}`)
      }))
    });
  }

}

exports.default = Settings;