"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Plane = Plane;
exports.Chase = Chase;
exports.Bounce = Bounce;
exports.Wave = Wave;
exports.Pulse = Pulse;
exports.Flow = Flow;
exports.Swing = Swing;
exports.Circle = Circle;
exports.CircleFade = CircleFade;
exports.Grid = Grid;
exports.FoldingCube = FoldingCube;
exports.Wander = Wander;

var _react = _interopRequireDefault(require("react"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Attribution: https://github.com/tobiasahlin/SpinKit
 *
 */
function classOf(cls, props) {
  return cls + (props.className ? ' ' + props.className : '');
}

function Plane(props) {
  return _react.default.createElement("div", {
    className: classOf('sk-plane', props)
  });
}

function Chase(props) {
  return _react.default.createElement("div", {
    className: classOf('sk-chase', props)
  }, _react.default.createElement("div", {
    className: "sk-chase-dot"
  }), _react.default.createElement("div", {
    className: "sk-chase-dot"
  }), _react.default.createElement("div", {
    className: "sk-chase-dot"
  }), _react.default.createElement("div", {
    className: "sk-chase-dot"
  }), _react.default.createElement("div", {
    className: "sk-chase-dot"
  }), _react.default.createElement("div", {
    className: "sk-chase-dot"
  }));
}

function Bounce(props) {
  return _react.default.createElement("div", {
    className: classOf('sk-bounce', props)
  }, _react.default.createElement("div", {
    className: "sk-bounce-dot"
  }), _react.default.createElement("div", {
    className: "sk-bounce-dot"
  }));
}

function Wave(props) {
  return _react.default.createElement("div", {
    className: classOf('sk-wave', props)
  }, _react.default.createElement("div", {
    className: "sk-wave-rect"
  }), _react.default.createElement("div", {
    className: "sk-wave-rect"
  }), _react.default.createElement("div", {
    className: "sk-wave-rect"
  }), _react.default.createElement("div", {
    className: "sk-wave-rect"
  }), _react.default.createElement("div", {
    className: "sk-wave-rect"
  }));
}

function Pulse(props) {
  return _react.default.createElement("div", {
    className: classOf('sk-pulse', props)
  });
}

function Flow(props) {
  return _react.default.createElement("div", {
    className: classOf('sk-flow', props)
  }, _react.default.createElement("div", {
    className: "sk-flow-dot"
  }), _react.default.createElement("div", {
    className: "sk-flow-dot"
  }), _react.default.createElement("div", {
    className: "sk-flow-dot"
  }));
}

function Swing(props) {
  return _react.default.createElement("div", {
    className: classOf('sk-swing', props)
  }, _react.default.createElement("div", {
    className: "sk-swing-dot"
  }), _react.default.createElement("div", {
    className: "sk-swing-dot"
  }));
}

function Circle(props) {
  return _react.default.createElement("div", {
    className: classOf('sk-circle', props)
  }, _react.default.createElement("div", {
    className: "sk-circle-dot"
  }), _react.default.createElement("div", {
    className: "sk-circle-dot"
  }), _react.default.createElement("div", {
    className: "sk-circle-dot"
  }), _react.default.createElement("div", {
    className: "sk-circle-dot"
  }), _react.default.createElement("div", {
    className: "sk-circle-dot"
  }), _react.default.createElement("div", {
    className: "sk-circle-dot"
  }), _react.default.createElement("div", {
    className: "sk-circle-dot"
  }), _react.default.createElement("div", {
    className: "sk-circle-dot"
  }), _react.default.createElement("div", {
    className: "sk-circle-dot"
  }), _react.default.createElement("div", {
    className: "sk-circle-dot"
  }), _react.default.createElement("div", {
    className: "sk-circle-dot"
  }), _react.default.createElement("div", {
    className: "sk-circle-dot"
  }));
}

function CircleFade(props) {
  return _react.default.createElement("div", {
    className: classOf('sk-circle-fade', props)
  }, _react.default.createElement("div", {
    className: "sk-circle-fade-dot"
  }), _react.default.createElement("div", {
    className: "sk-circle-fade-dot"
  }), _react.default.createElement("div", {
    className: "sk-circle-fade-dot"
  }), _react.default.createElement("div", {
    className: "sk-circle-fade-dot"
  }), _react.default.createElement("div", {
    className: "sk-circle-fade-dot"
  }), _react.default.createElement("div", {
    className: "sk-circle-fade-dot"
  }), _react.default.createElement("div", {
    className: "sk-circle-fade-dot"
  }), _react.default.createElement("div", {
    className: "sk-circle-fade-dot"
  }), _react.default.createElement("div", {
    className: "sk-circle-fade-dot"
  }), _react.default.createElement("div", {
    className: "sk-circle-fade-dot"
  }), _react.default.createElement("div", {
    className: "sk-circle-fade-dot"
  }), _react.default.createElement("div", {
    className: "sk-circle-fade-dot"
  }));
}

function Grid(props) {
  return _react.default.createElement("div", {
    className: classOf('sk-grid', props)
  }, _react.default.createElement("div", {
    className: "sk-grid-cube"
  }), _react.default.createElement("div", {
    className: "sk-grid-cube"
  }), _react.default.createElement("div", {
    className: "sk-grid-cube"
  }), _react.default.createElement("div", {
    className: "sk-grid-cube"
  }), _react.default.createElement("div", {
    className: "sk-grid-cube"
  }), _react.default.createElement("div", {
    className: "sk-grid-cube"
  }), _react.default.createElement("div", {
    className: "sk-grid-cube"
  }), _react.default.createElement("div", {
    className: "sk-grid-cube"
  }), _react.default.createElement("div", {
    className: "sk-grid-cube"
  }));
}

function FoldingCube(props) {
  return _react.default.createElement("div", {
    className: classOf('sk-fold', props)
  }, _react.default.createElement("div", {
    className: "sk-fold-cube"
  }), _react.default.createElement("div", {
    className: "sk-fold-cube"
  }), _react.default.createElement("div", {
    className: "sk-fold-cube"
  }), _react.default.createElement("div", {
    className: "sk-fold-cube"
  }));
}

function Wander(props) {
  return _react.default.createElement("div", {
    className: classOf('sk-wander', props)
  }, _react.default.createElement("div", {
    className: "sk-wander-cube"
  }), _react.default.createElement("div", {
    className: "sk-wander-cube"
  }), _react.default.createElement("div", {
    className: "sk-wander-cube"
  }));
}