"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _reactCore = require("@patternfly/react-core");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2021 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
class PatternFlyAlert extends _react.default.PureComponent {
  constructor(props) {
    super(props);
    this._onClose = this.onClose.bind(this);
    this.state = PatternFlyAlert.getDerivedStateFromProps(props);
  }

  static getDerivedStateFromProps(props, state) {
    if (!state || props !== state.props) {
      return {
        props,
        isClosed: false
      };
    } else {
      return state;
    }
  }

  onClose() {
    if (this.props.onCloseButtonClick) {
      this.props.onCloseButtonClick();
    }

    this.setState({
      isClosed: true
    });
  }

  render() {
    return this.state.isClosed ? _react.default.createElement(_react.default.Fragment, null) : _react.default.createElement(_reactCore.Alert, {
      id: this.props.id || '',
      className: 'kui--toolbar-alert ' + (this.props.className || ''),
      "data-type": this.props.alert.type,
      title: this.props.alert.title,
      actionClose: !this.props.hideCloseButton && _react.default.createElement(_reactCore.AlertActionCloseButton, {
        onClose: this._onClose
      }),
      timeout: this.props.timeout,
      onTimeout: this._onClose,
      isInline: !this.props.isGlobal,
      variant: this.props.alert.type === 'error' ? 'danger' : this.props.alert.type
    }, _react.default.createElement(_react.default.Fragment, null, this.props.alert.body || '', this.props.children));
  }

}

exports.default = PatternFlyAlert;