/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import React from 'react';
import Alert from '../../spi/Alert';
import Toolbar from './Toolbar';
export default class ToolbarContainer extends React.PureComponent {
    constructor(props) {
        super(props);
        this._willUpdateToolbar = this.onToolbarUpdate.bind(this);
        this.state = {};
    }
    /** Called by children if they desire an update to the Toolbar */
    onToolbarUpdate(toolbarText, extraButtons, extraButtonsOverride) {
        this.setState({ extraButtons, extraButtonsOverride });
        if (toolbarText &&
            (!this.props.toolbarText ||
                toolbarText.type !== this.props.toolbarText.type ||
                toolbarText.text !== this.props.toolbarText.text ||
                toolbarText.alerts !== this.props.toolbarText.alerts)) {
            this.props.didUpdateToolbar(toolbarText);
        }
    }
    /** Graft on the toolbar event management */
    children() {
        if (React.isValidElement(this.props.children)) {
            // ^^^ this check avoids tsc errors
            return React.cloneElement(this.props.children, { willUpdateToolbar: this._willUpdateToolbar });
        }
        else {
            return this.props.children;
        }
    }
    render() {
        const toolbarButtons = this.state.extraButtonsOverride && Array.isArray(this.state.extraButtons)
            ? this.state.extraButtons
            : this.props.buttons.concat(this.state.extraButtons || []);
        const toolbarHasContent = this.props.toolbarText || toolbarButtons.length !== 0;
        const toolbarHasAlerts = !this.props.noAlerts &&
            this.props.toolbarText &&
            this.props.toolbarText.alerts &&
            this.props.toolbarText.alerts.length !== 0;
        return (React.createElement("div", { className: "full-height" },
            toolbarHasContent && (React.createElement(Toolbar, { tab: this.props.tab, execUUID: this.props.execUUID, response: this.props.response, args: this.props.args, toolbarText: this.props.toolbarText, buttons: toolbarButtons })),
            toolbarHasAlerts && (React.createElement(React.Suspense, { fallback: React.createElement("div", null) }, this.props.toolbarText.alerts.map((alert, id) => (React.createElement(Alert, { key: id, alert: alert }))))),
            React.createElement(React.Suspense, { fallback: React.createElement("div", null) }, this.children())));
    }
}
//# sourceMappingURL=ToolbarContainer.js.map