"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.doDelete = void 0;

var _flags = _interopRequireDefault(require("./flags"));

var _exec = require("./exec");

var _delete = _interopRequireDefault(require("../client/direct/delete"));

var _states = require("../../lib/model/states");

var _help = require("../../lib/util/help");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2019 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = void 0 && (void 0).__awaiter || function (thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function (resolve) {
      resolve(value);
    });
  }

  return new (P || (P = Promise))(function (resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }

    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }

    function step(result) {
      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
    }

    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
};

/**
 * Prepare the command line for delete: by default, apparently,
 * kubernetes treats finalizers as synchronous, and --wait defaults to
 * true
 *
 */
function prepareArgsForDelete(args) {
  if (!Object.prototype.hasOwnProperty.call(args.parsedOptions, 'wait')) {
    return args.command + ' --wait=false';
  } else {
    return args.command;
  }
}

const doDelete = (command = 'kubectl') => args => __awaiter(void 0, void 0, void 0, function* () {
  if ((0, _help.isUsage)(args)) {
    return (0, _help.doHelp)(command, args, prepareArgsForDelete);
  } else {
    try {
      const directResponse = yield (0, _delete.default)(args);

      if (directResponse) {
        return directResponse;
      }
    } catch (err) {
      if (err.code === 404) {
        throw err;
      } else {
        console.error('Error in direct delete. Falling back to CLI delete.', err.code, err);
      }
    }

    return (0, _exec.doExecWithStatus)('delete', _states.FinalState.OfflineLike, command, prepareArgsForDelete)(args);
  }
});

exports.doDelete = doDelete;

var _default = registrar => {
  registrar.listen('/kubectl/delete', doDelete(), _flags.default);
  registrar.listen('/k/delete', doDelete(), _flags.default);
};

exports.default = _default;