import { Entity } from './entity';
import REPL from './repl';
export declare type CommentaryResponse = {
    apiVersion: 'kui-shell/v1';
    kind: 'CommentaryResponse';
    props: {
        /** Content rendered inside the CardTitle */
        title?: string;
        /** Body of the Card. It will be passed through as the source <Markdown source="..." /> */
        children: string;
        /** Prefix for image URLs */
        baseUrl?: string;
        /** [Optional] REPL controller, but required if you want your Card
         * to have functional kuiexec?command=... links via Markdown */
        repl?: REPL;
    };
};
export declare function isCommentaryResponse(entity: Entity): entity is CommentaryResponse;
