"use strict";
/*
 * Copyright 2021 IBM
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.isColorSet = void 0;
function isHSL(o) {
    var hsl = o;
    return hsl &&
        typeof hsl.hue === 'string' &&
        typeof hsl.saturation === 'string' &&
        typeof hsl.lightness === 'string';
}
function isColor(o) {
    return isHSL(o);
}
function isColorSet(o) {
    return Array.isArray(o) && o.length > 0 && Array.isArray(o[0]) && isColor(o[0][0]);
}
exports.isColorSet = isColorSet;
//# sourceMappingURL=ColorSet.js.map