import { Color } from './ColorSet';
import Options from './options';
declare type Assignment<C = Color> = {
    primary: number;
    secondary: number;
    color: C;
    /** Did we get a bucket conflict, and have to resort to a random color assignment? */
    isRandomAssignment: boolean;
};
/**
 * Takes a list of N strings, and returns a parallel list of N
 * colors. The number of distinct colors in the return value will be
 * M, where M is given by options.colorSet or the default color set,
 * which has 6 primary colors, and 4 secondary colors.
 *
 * @return array of hex strings
 *
 */
export default function colorize(A: string[], options?: Options): Assignment<string>[];
export {};
