"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.cwd = exports.default = exports.expandHomeDir = void 0;

var _path = require("path");

var _os = require("os");

var _capabilities = require("../core/capabilities");

/*
 * Copyright 2019 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
const homedir = (0, _os.homedir)();

const expandHomeDir = function (path) {
  if (!path) {
    return path;
  } else if (path === '~') {
    return homedir;
  } else if (path.slice(0, 2) !== '~/' && path.slice(0, 2) !== '~\\') {
    return path;
  } else {
    return (0, _path.join)(homedir, path.slice(2));
  }
};

exports.expandHomeDir = expandHomeDir;
var _default = expandHomeDir;
exports.default = _default;

const cwd = () => process.env.VIRTUAL_CWD || ((0, _capabilities.inBrowser)() ? process.env.PWD || process.env.HOME || '/' : process.cwd().slice(0));

exports.cwd = cwd;