"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.bootIntoSandbox = bootIntoSandbox;
exports.default = void 0;

var _client = require("./client");

/*
 * Copyright 2018 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = void 0 && (void 0).__awaiter || function (thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function (resolve) {
      resolve(value);
    });
  }

  return new (P || (P = Promise))(function (resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }

    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }

    function step(result) {
      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
    }

    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
};

function catastrophe(err) {
  console.error('restart needed');
  console.error(err);
  document.body.classList.add('oops-total-catastrophe');
}

function initCommandRegistrar() {
  return __awaiter(this, void 0, void 0, function* () {
    const {
      init
    } = yield Promise.resolve().then(() => require('../../commands/tree'));
    yield init();
  });
}
/**
 * Invoked on the domReady event.
 *
 * @param { Client } clientMain client-provided renderer of main content
 *
 */


const domReady = (inSandbox, client) => () => __awaiter(void 0, void 0, void 0, function* () {
  const initializer = Promise.resolve().then(() => require('./init'));
  const plugins = Promise.resolve().then(() => require('../../plugins/plugins'));
  const events = Promise.resolve().then(() => require('../../core/events'));

  try {
    const waitForThese = [];
    const commands = initCommandRegistrar();
    waitForThese.push(plugins.then(_ => __awaiter(void 0, void 0, void 0, function* () {
      yield _.init();
      yield commands;
      yield _.preload();
    })));
    waitForThese.push(document.body.classList.contains('in-electron') ? Promise.resolve().then(() => require('../electron-events')).then(_ => _.init()) : Promise.resolve());
    waitForThese.push(waitForThese[1].then(() => initializer).then(_ => _.init())); // await query.then(_ => _.init())

    yield Promise.all(waitForThese);
    document.body.classList.remove('still-loading');
    events.then(eventChannelUnsafe => {
      eventChannelUnsafe.default.emit('/init/done');

      if (client) {
        const root = document.body.querySelector('main');

        if (!inSandbox && !(0, _client.inBrowser)()) {
          // if in Electron, then see if the init-electron code wants to special case things
          Promise.resolve().then(() => require('./init-electron')).then(_ => _.render(client, root));
        } else {
          client(root, false);
        }
      }
    });
  } catch (err) {
    catastrophe(err);
  }
});
/**
 * Usage: clients will invoke this with their main renderer.
 *
 * For reference, the HTML template is to be found in
 * ../../../templates/index.ejs. This template is in turn managed by
 * packages/webpack/webpack.config.js.
 *
 * @param renderer a function that injects its content into the given
 * container
 *
 */


var _default = client => __awaiter(void 0, void 0, void 0, function* () {
  Promise.resolve().then(() => require('./init')).then(_ => _.preinit(false));
  window.addEventListener('load', domReady(false, client), {
    once: true
  });
});
/** For booting into an external browser sandbox, such as codesandbox.io */


exports.default = _default;

function bootIntoSandbox() {
  return __awaiter(this, void 0, void 0, function* () {
    const {
      setMedia,
      Media,
      assertInSandbox
    } = yield Promise.resolve().then(() => require('../../core/capabilities'));
    assertInSandbox();
    setMedia(Media.Browser);
    yield Promise.resolve().then(() => require('./init')).then(_ => _.preinit(true));
    yield domReady(true)();
  });
}