import { MenuItemConstructorOptions } from 'electron';
interface OpenNotebookItem {
    label: string;
    click: () => void;
}
interface NotebookDefinitionMenuItem {
    notebook: string;
    filepath: string;
}
interface SeparatorMenuItem {
    type: 'separator';
}
declare type NotebookMenuItem = NotebooksMenu | NotebookDefinitionMenuItem | SeparatorMenuItem;
interface NotebooksMenu {
    label: string;
    submenu: NotebookMenuItem[];
}
/** Open a new window or tab and replay the contents of the given `filepath` */
export declare function replay(filepath: string, createWindow: (executeThisArgvPlease?: string[]) => void): void;
/** @return a menu item that opens the given notebook */
export declare function openNotebook(createWindow: (executeThisArgvPlease?: string[]) => void, label: string, filepath: string): OpenNotebookItem;
/** We only need to replace the NotebookDefinitionMenuItem with calls to our `notebook` helper */
export declare function clientNotebooksDefinitionToElectron(defn: NotebooksMenu, notebook: (label: string, filepath: string) => OpenNotebookItem): MenuItemConstructorOptions;
/** @return the client's definition of a Notebooks menu */
export declare function loadClientNotebooksMenuDefinition(): NotebooksMenu;
export {};
