import { Entity, MarkdownResponse } from './entity';
/**
 * If your controller wants to manipulate the tab layout, this is your
 * response type!
 *
 */
declare type TabLayoutModificationResponse<Request extends ModificationRequest = ModificationRequest> = {
    apiVersion: 'kui-shell/v1';
    kind: 'TabLayoutModificationResponse';
    spec: Request & {
        ok: MarkdownResponse;
    };
};
export declare type NewSplitRequest = {
    modification: 'NewSplit';
    options?: {
        /** Splice the split at this index; default (and if out of range) is at-end */
        index?: number;
        /** Use an inverted color scheme for the new split? */
        inverseColors?: boolean;
        /** Execute this command line in the new split */
        cmdline?: string;
        /** Only perform the split if the given command returns true */
        if?: string;
        /** Only perform the split if the given command returns false */
        ifnot?: string;
    };
};
declare type ModificationRequest = NewSplitRequest;
export declare function isNewSplitRequest(req: TabLayoutModificationResponse): req is TabLayoutModificationResponse<NewSplitRequest>;
export declare function isTabLayoutModificationResponse(entity: Entity): entity is TabLayoutModificationResponse;
export default TabLayoutModificationResponse;
