/*
 * Copyright 2019 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import { UsageError } from '../core/usage-error';
export function isCodedError(err) {
    const error = err;
    return !!(UsageError.isUsageError(err) || error.code !== undefined || error.statusCode !== undefined);
}
export function is404(err) {
    const error = err;
    return !!(error.code === 404 || error.statusCode === 404);
}
export function is409(err) {
    const error = err;
    return !!(error.code === 409 || error.statusCode === 409);
}
export function is404or409(err) {
    const error = err;
    const code = error.code || error.statusCode;
    return code === 404 || code === 409;
}
//# sourceMappingURL=errors.js.map