import { Tab } from '../../tab';
import { MetadataBearing } from '../../../models/entity';
import { ModeOrButton as SidecarMode } from '../../../models/mmr/types';
export declare type SidecarModeFilter<Resource extends MetadataBearing> = (resource: Resource) => boolean;
export declare type ModeDeclaration<Resource extends MetadataBearing> = SidecarMode;
/**
 * Interpretation: if the resource passes the given "when" filter,
 * then add the given sidecar mode
 *
 */
export interface ModeRegistration<Resource extends MetadataBearing> {
    when: SidecarModeFilter<Resource>;
    mode: ModeDeclaration<Resource>;
}
/**
 * Register a new mode
 *
 */
export declare function registerSidecarMode<Resource extends MetadataBearing>(registration: ModeRegistration<Resource>): void;
export default registerSidecarMode;
export declare const registerModeWhen: <Resource extends MetadataBearing<void>>(when: SidecarModeFilter<Resource>) => (mode: ModeDeclaration<Resource>) => void;
/**
 * Apply all registered modes that are relevant to the given resource
 * to the given modes model
 *
 */
export declare function apply<Resource extends MetadataBearing>(tab: Tab, modes: SidecarMode[], command: string, resource: {
    resource: Resource;
}): void;
/**
 * @return the relevant modes for the given command on the given resource
 *
 */
