import { ReturnValue } from './return-value';
export declare class PromisePool<T> {
    /**
     * The processable items.
     */
    private readonly items;
    /**
     * The number of promises running concurrently.
     */
    private concurrency;
    /**
     * The error handler callback function
     */
    private errorHandler?;
    /**
     * Instantiates a new promise pool with a default `concurrency: 10` and `items: []`.
     *
     * @param {Object} options
     */
    constructor(items?: T[]);
    /**
     * Set the number of tasks to process concurrently in the promise pool.
     *
     * @param {Integer} concurrency
     *
     * @returns {PromisePool}
     */
    withConcurrency(concurrency: number): PromisePool<T>;
    /**
     * Set the number of tasks to process concurrently in the promise pool.
     *
     * @param {Number} concurrency
     *
     * @returns {PromisePool}
     */
    static withConcurrency(concurrency: number): PromisePool<unknown>;
    /**
     * Set the items to be processed in the promise pool.
     *
     * @param {Array} items
     *
     * @returns {PromisePool}
     */
    for<T>(items: T[]): PromisePool<T>;
    /**
     * Set the items to be processed in the promise pool.
     *
     * @param {Array} items
     *
     * @returns {PromisePool}
     */
    static for<T>(items: T[]): PromisePool<T>;
    /**
     * Set the error handler function to execute when an error occurs.
     *
     * @param {Function} handler
     *
     * @returns {PromisePool}
     */
    handleError(handler: (error: Error, item: T) => Promise<void> | void): PromisePool<T>;
    /**
     * Starts processing the promise pool by iterating over the items
     * and running each item through the async `callback` function.
     *
     * @param {Function} The async processing function receiving each item from the `items` array.
     *
     * @returns Promise<{ results, errors }>
     */
    process<R>(callback: (item: T) => R | Promise<R>): Promise<ReturnValue<T, R>>;
}
