"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _pluginClientCommon = require("@kui-shell/plugin-client-common");

var _SearchInput = _interopRequireDefault(require("./SearchInput"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var __awaiter = void 0 && (void 0).__awaiter || function (thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function (resolve) {
      resolve(value);
    });
  }

  return new (P || (P = Promise))(function (resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }

    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }

    function step(result) {
      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
    }

    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
};

class CustomSearchInput extends _pluginClientCommon.InputProvider {
  constructor(props) {
    super(props);

    this.handleInputTextChange = e => {
      if (e.target.value === 'search ') {
        this.setState({
          inputText: e.target.value,
          isSearch: true
        });
      }
    };

    this.handleSearchTextChange = currentQuery => {
      const query = currentQuery.replace(/:\s*/, ':');
      this.toggleIsSearchState(query);
    };

    this.onKeyPress = e => __awaiter(this, void 0, void 0, function* () {
      const {
        inputText,
        isSearch
      } = this.state;
      e.persist();

      if (e.which === 13) {
        this.setState({
          isSearch: false,
          inputText: e.target.value
        });

        if (isSearch) {
          const unfinishedText = document.querySelector('.kui--input-stripe .repl-block input')['value'];
          const searchCommand = inputText.endsWith(':') || inputText.endsWith(' ') ? inputText + unfinishedText : inputText + ' ' + unfinishedText;

          if (searchCommand.trim() === 'search') {
            yield require('@kui-shell/core').doEval(this.props.tab, undefined, 'search -h');
          } else {
            try {
              yield require('@kui-shell/core').doEval(this.props.tab, undefined, searchCommand);
            } catch (error) {
              console.error(error);
            }
          }
        }
      }
    });

    this.state = Object.assign(this.state || {}, {
      model: props.model,
      inputText: '',
      isSearch: false
    });
  }

  toggleIsSearchState(inputText) {
    if (inputText.startsWith('search ') && !this.state.isSearch) {
      this.setState({
        isSearch: true,
        inputText
      });
    } else if (!inputText.startsWith('search') && this.state.isSearch) {
      this.setState({
        isSearch: false,
        inputText
      });
    } else {
      this.setState({
        inputText
      });
    }
  }

  renderSearchComponents() {
    return /*#__PURE__*/_react.default.createElement(_SearchInput.default, {
      onChange: this.handleSearchTextChange,
      value: this.state.inputText,
      onKeyPress: this.onKeyPress
    });
  }

  input() {
    return this.state.isSearch ? this.renderSearchComponents() : /*#__PURE__*/_react.default.createElement("input", {
      autoFocus: true,
      autoCorrect: "off",
      autoComplete: "off",
      spellCheck: "false",
      autoCapitalize: "off",
      key: this.props.idx,
      className: "repl-input-element",
      onChange: this.handleInputTextChange,
      onKeyPress: _pluginClientCommon.defaultOnKeyPress.bind(this),
      onKeyDown: _pluginClientCommon.defaultOnKeyDown.bind(this),
      onKeyUp: _pluginClientCommon.defaultOnKeyUp.bind(this),
      ref: prompt => {
        if (prompt) {
          prompt.focus();
          this.setState({
            prompt
          });
        }
      }
    });
  }

}

exports.default = CustomSearchInput;