"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIntroduction = exports.getTableContent = void 0;

var _react = _interopRequireDefault(require("react"));

var _reactDom = _interopRequireDefault(require("react-dom"));

var _core = require("@kui-shell/core");

var _iconsReact = require("@carbon/icons-react");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const getTableContent = data => {
  const node = document.createElement('div');
  node.classList.add('bx--data-table-container');

  const content = () => {
    return /*#__PURE__*/_react.default.createElement("table", {
      className: "bx--data-table bx--data-table--short bx--data-table--no-border"
    }, /*#__PURE__*/_react.default.createElement("thead", null, /*#__PURE__*/_react.default.createElement("tr", {
      className: "bx--data-table--compact"
    }, data.headers.map(res => {
      return /*#__PURE__*/_react.default.createElement("th", {
        key: res.key
      }, res.header.toUpperCase());
    }))), /*#__PURE__*/_react.default.createElement("tbody", null, data.rows.map(res => {
      return /*#__PURE__*/_react.default.createElement("tr", {
        className: "bx--data-table--compact",
        key: res.name
      }, /*#__PURE__*/_react.default.createElement("td", {
        onClick: () => (0, _core.getCurrentTab)().REPL.pexec(res.command)
      }, res.name), /*#__PURE__*/_react.default.createElement("td", null, res.docs));
    })));
  };

  _reactDom.default.render( /*#__PURE__*/_react.default.createElement(content), node);

  return node;
};

exports.getTableContent = getTableContent;

const getIntroduction = data => {
  const node = document.createElement('div');

  const content = () => {
    return /*#__PURE__*/_react.default.createElement("div", null, data.map(res => {
      return /*#__PURE__*/_react.default.createElement("div", {
        key: res.header
      }, /*#__PURE__*/_react.default.createElement("h3", {
        className: `${res.header.toLowerCase()}-header`
      }, /*#__PURE__*/_react.default.createElement("strong", null, res.header)), /*#__PURE__*/_react.default.createElement("p", null, res.docs), res.usage ? /*#__PURE__*/_react.default.createElement("div", {
        className: "bx--snippet bx--snippet--single search"
      }, res.usage, /*#__PURE__*/_react.default.createElement(_iconsReact.Copy24, {
        className: 'copy-btn'
      })) : null);
    }));
  };

  _reactDom.default.render( /*#__PURE__*/_react.default.createElement(content), node);

  return node;
};

exports.getIntroduction = getIntroduction;