"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usage = usage;

var _i18n = _interopRequireDefault(require("../../util/i18n"));

var _searchSidecarHelp = require("./search-sidecar-help");

var _pluginState = require("../../pluginState");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const breadcrumb = argv => {
  const flags = (0, _pluginState.getPluginState)().flags;

  if (flags.includes(argv[argv.length - 1])) {
    argv.pop();
  }

  const crumbs = argv.map(cmd => ({
    label: cmd,
    command: `${cmd === 'search' ? ` ${cmd} -h` : undefined}`
  }));
  return crumbs;
};

const contentType = 'text/html';
const apiVersion = 'kui-shell/v1';
const kind = 'NavResponse';
const sections = {
  introduction: {
    headers: [{
      header: (0, _i18n.default)('validation.about'),
      docs: (0, _i18n.default)('searchhelp.title'),
      key: (0, _i18n.default)('validation.about')
    }, {
      header: (0, _i18n.default)('validation.usage'),
      docs: (0, _i18n.default)('searchhelp.header'),
      key: (0, _i18n.default)('validation.usage'),
      usage: `search [${(0, _i18n.default)('validation.definition.option')}][${(0, _i18n.default)('validation.definition.flag')}]`
    }, {
      header: (0, _i18n.default)('validation.guide'),
      docs: (0, _i18n.default)('searchhelp.guide.docs', [`search <${'searchhelp.definition.command'}> -h`]),
      key: (0, _i18n.default)('validation.guide')
    }]
  },
  commands: {
    headers: [{
      header: (0, _i18n.default)('validation.commands'),
      key: (0, _i18n.default)('validation.commands')
    }, {
      header: (0, _i18n.default)('validation.docs'),
      key: (0, _i18n.default)('validation.definition.docs')
    }],
    rows: [{
      command: 'search summary',
      name: 'summary',
      docs: (0, _i18n.default)('searchhelp.search.summary.docs')
    }, {
      command: 'search --related',
      name: '--related',
      docs: (0, _i18n.default)('searchhelp.search.related.resources.docs')
    }]
  },
  options: {
    headers: [{
      header: (0, _i18n.default)('validation.option'),
      key: (0, _i18n.default)('validation.option')
    }, {
      header: (0, _i18n.default)('validation.docs'),
      key: (0, _i18n.default)('validation.definition.docs')
    }],
    rows: [{
      command: 'search kind:pod --save',
      name: '--save',
      docs: (0, _i18n.default)('searchhelp.search.save.docs')
    }, {
      command: 'search -delete="save"',
      name: '-delete="save"',
      docs: (0, _i18n.default)('delete.savedsearchhelp.title')
    }, {
      command: 'search -delete="resource"',
      name: '-delete="resource"',
      docs: (0, _i18n.default)('delete.resourcehelp.title')
    }]
  },
  summary: {
    headers: [{
      header: (0, _i18n.default)('validation.about'),
      docs: (0, _i18n.default)('searchhelp.title'),
      key: (0, _i18n.default)('validation.about')
    }]
  }
};

function usage(args) {
  return {
    apiVersion,
    kind,
    breadcrumbs: breadcrumb(args),
    menus: [{
      label: (0, _i18n.default)('validation.usage'),
      items: [{
        mode: (0, _i18n.default)('validation.introduction'),
        content: (0, _searchSidecarHelp.getIntroduction)(sections.introduction.headers),
        contentType
      }, {
        mode: (0, _i18n.default)('validation.option'),
        content: (0, _searchSidecarHelp.getTableContent)(sections.options),
        contentType
      }]
    }, {
      label: (0, _i18n.default)('validation.commands'),
      items: [{
        mode: `${(0, _i18n.default)('validation.basic')} (${(0, _i18n.default)('validation.beginner')})`,
        content: (0, _searchSidecarHelp.getTableContent)(sections.commands),
        contentType
      }]
    }],
    links: [{
      label: (0, _i18n.default)('validation.more.information'),
      href: 'https://access.redhat.com/documentation/en-us/red_hat_advanced_cluster_management_for_kubernetes/2.3/html-single/web_console/index?lb_target=production#searching-with-visual-web-terminal'
    }]
  };
}