"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSidecar = exports.buildSidecar = void 0;

var _searchHelper = require("../util/search-helper");

var _lodash = _interopRequireDefault(require("lodash"));

var _HTTPClient = _interopRequireDefault(require("./HTTPClient"));

var _searchQueries = require("../definitions/search-queries");

var _summary = require("../views/modes/summary");

var _yaml = require("../views/modes/yaml");

var _related = require("../views/modes/related");

var _logging = require("../views/modes/logging");

var _i18n = _interopRequireDefault(require("../util/i18n"));

var _search = require("./search");

var _pluginState = require("../pluginState");

var _searchhelp = require("./helpfiles/searchhelp");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var __awaiter = void 0 && (void 0).__awaiter || function (thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function (resolve) {
      resolve(value);
    });
  }

  return new (P || (P = Promise))(function (resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }

    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }

    function step(result) {
      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
    }

    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
};

const buildSidecar = (type, data, resource, cmd) => {
  const modes = [];

  const kind = _lodash.default.get(data, 'items[0].kind', '');

  if (type !== 'query') {
    modes.push((0, _summary.summaryTab)(data.items[0]));

    if (kind === 'pod') {
      modes.push((0, _logging.logTab)(data.items[0]));
    }

    if (!_lodash.default.get(resource, 'errors', '') && _lodash.default.get(data, 'getResource', '') === '' && kind !== 'cluster') {
      modes.push((0, _yaml.yamlTab)(resource, data, cmd));
    }
  }

  if (_lodash.default.get(data, 'related', '').length > 0) {
    modes.push((0, _related.relatedTab)(data, type));
  }

  return {
    kind,
    metadata: {
      name: type !== 'query' ? _lodash.default.get(data, 'items[0].name', '') : (0, _i18n.default)('search.label.query', [kind]),
      namespace: type !== 'query' ? _lodash.default.get(data, 'items[0].namespace', '') : null
    },
    modes
  };
};

exports.buildSidecar = buildSidecar;

const getSidecar = args => __awaiter(void 0, void 0, void 0, function* () {
  return new Promise(resolve => {
    const {
      command,
      argv
    } = args;
    const userQuery = (0, _searchHelper.convertStringToQuery)(command);

    if (argv.length === 2 || (0, _pluginState.getPluginState)().flags.includes(argv[2])) {
      resolve((0, _searchhelp.usage)(argv));
    }

    (0, _HTTPClient.default)('post', 'search', (0, _searchQueries.SEARCH_RELATED_QUERY)(userQuery.keywords, userQuery.filters)).then(res => {
      const err = _lodash.default.get(res, 'errors[0].message', '');

      if (err) {
        resolve((0, _search.renderSearchAvailable)(err));
      }

      const data = _lodash.default.get(res, 'data.searchResult[0]', '');

      const kind = _lodash.default.get(data, 'items[0].kind', '');

      if (!data || data.items.length === 0 && data.related.length === 0) {
        resolve((0, _pluginState.resourceNotFound)());
      }

      if (args.command.includes('--related')) {
        resolve(buildSidecar('query', data));
      } else if (kind === 'cluster') {
        resolve(buildSidecar('resource', data));
      } else {
        (0, _HTTPClient.default)('post', 'console', (0, _searchQueries.SEARCH_ACM_QUERY)(data.items[0])).then(resp => {
          let resource;

          if (kind === 'cluster') {
            resource = resp.data.items.filter(cluster => cluster.metadata.name === data.items[0].name);
          } else {
            resource = !resp.errors ? resp.data.getResource : resp;
          }

          resolve(buildSidecar('resource', data, resource, command));
        }).catch(() => {
          resolve((0, _search.renderSearchAvailable)());
        });
      }
    }).catch(() => {
      resolve((0, _search.renderSearchAvailable)());
    });
  });
});

exports.getSidecar = getSidecar;