'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAge = void 0;

var _lodash = _interopRequireDefault(require("lodash"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const moment = require('moment');

const getAge = (item, timestampKey) => {
  const key = timestampKey || 'created';

  const createdTime = _lodash.default.get(item, key);

  return moment(createdTime, 'YYYY-MM-DDTHH:mm:ssZ').fromNow();
};

exports.getAge = getAge;