var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import React from 'react';
import { InputProvider, defaultOnKeyDown, defaultOnKeyPress, defaultOnKeyUp } from '@kui-shell/plugin-client-common';
import SearchInput from './SearchInput';
import '../../web/scss/index.scss';
export default class CustomSearchInput extends InputProvider {
    constructor(props) {
        super(props);
        this.handleInputTextChange = e => {
            if (e.target.value === 'search ') {
                this.setState({ inputText: e.target.value, isSearch: true });
            }
        };
        this.handleSearchTextChange = currentQuery => {
            const query = currentQuery.replace(/:\s*/, ':');
            this.toggleIsSearchState(query);
        };
        this.onKeyPress = (e) => __awaiter(this, void 0, void 0, function* () {
            const { inputText, isSearch } = this.state;
            e.persist();
            if (e.which === 13) {
                this.setState({ isSearch: false, inputText: e.target.value });
                if (isSearch) {
                    const unfinishedText = document.querySelector('.kui--input-stripe .repl-block input')['value'];
                    const searchCommand = inputText.endsWith(':') || inputText.endsWith(' ')
                        ? inputText + unfinishedText
                        : inputText + ' ' + unfinishedText;
                    if (searchCommand.trim() === 'search') {
                        yield require('@kui-shell/core').doEval(this.props.tab, undefined, 'search -h');
                    }
                    else {
                        try {
                            yield require('@kui-shell/core').doEval(this.props.tab, undefined, searchCommand);
                        }
                        catch (error) {
                            console.error(error);
                        }
                    }
                }
            }
        });
        this.state = Object.assign(this.state || {}, {
            model: props.model,
            inputText: '',
            isSearch: false
        });
    }
    toggleIsSearchState(inputText) {
        if (inputText.startsWith('search ') && !this.state.isSearch) {
            this.setState({ isSearch: true, inputText });
        }
        else if (!inputText.startsWith('search') && this.state.isSearch) {
            this.setState({ isSearch: false, inputText });
        }
        else {
            this.setState({ inputText });
        }
    }
    renderSearchComponents() {
        return (React.createElement(SearchInput, { onChange: this.handleSearchTextChange, value: this.state.inputText, onKeyPress: this.onKeyPress }));
    }
    input() {
        return this.state.isSearch ? (this.renderSearchComponents()) : (React.createElement("input", { autoFocus: true, autoCorrect: "off", autoComplete: "off", spellCheck: "false", autoCapitalize: "off", key: this.props.idx, className: "repl-input-element", onChange: this.handleInputTextChange, onKeyPress: defaultOnKeyPress.bind(this), onKeyDown: defaultOnKeyDown.bind(this), onKeyUp: defaultOnKeyUp.bind(this), ref: prompt => {
                if (prompt) {
                    prompt.focus();
                    this.setState({ prompt });
                }
            } }));
    }
}
//# sourceMappingURL=CustomSearchInput.js.map