import React from 'react';
import SearchBar from './SearchBar';
import strings from '../util/i18n';
import { getPluginState } from '../pluginState';
export default class SearchInput extends React.PureComponent {
    constructor(props) {
        super(props);
        this.state = {
            searchSchema: [{ id: 'loading', name: strings('search.loading'), disabled: true }]
        };
    }
    componentDidMount() {
        if (getPluginState().searchSchema.length > 0) {
            this.setState({ searchSchema: getPluginState().searchSchema });
        }
        else {
            this.setState({ searchSchema: getPluginState().default });
        }
    }
    render() {
        return (React.createElement(SearchBar, { onKeyPress: this.props.onKeyPress, value: this.props.value, onChange: this.props.onChange, availableFilters: this.state.searchSchema }));
    }
}
SearchInput.propTypes = {};
//# sourceMappingURL=SearchInput.js.map