import lodash from 'lodash';
import React from 'react';
import ReactDOM from 'react-dom';
import { StructuredListWrapper, StructuredListBody, StructuredListRow, StructuredListCell } from 'carbon-components-react';
import strings from '../../util/i18n';
export const buildSummary = (items) => {
    const node = document.createElement('div');
    node.classList.add('scrollable');
    node.classList.add('bx--structured-list--summary');
    const rows = Object.entries(items).filter(key => !key[0][0].match('_'));
    const summary = () => {
        return (React.createElement(StructuredListWrapper, null,
            React.createElement(StructuredListBody, null, rows.map(row => (React.createElement(StructuredListRow, { key: lodash.get(row, '[0]', '') },
                React.createElement(StructuredListCell, null,
                    React.createElement("span", { className: "bx--structured-list-td-header" }, `${row[0]}`),
                    React.createElement("br", null),
                    React.createElement("span", { className: "bx--structured-list-td-body" }, `${row[1]}`))))))));
    };
    ReactDOM.render(React.createElement(summary), node);
    return node;
};
export const summaryTab = (items) => {
    return {
        mode: 'summaryTab',
        defaultMode: true,
        label: strings('search.label.summary'),
        order: 1,
        content: buildSummary(items)
    };
};
//# sourceMappingURL=summary.js.map