/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { ls, fslice, fstat, fwrite } from '../delegates';
export function lsImpl(args) {
    return __awaiter(this, void 0, void 0, function* () {
        return {
            mode: 'raw',
            content: yield ls(args, args.argvNoOptions.slice(2))
        };
    });
}
export function fwriteImpl(args) {
    return __awaiter(this, void 0, void 0, function* () {
        return {
            mode: 'raw',
            content: yield fwrite(args, args.argvNoOptions[2], args.execOptions.data)
        };
    });
}
export function fstatImpl(args) {
    return __awaiter(this, void 0, void 0, function* () {
        return {
            mode: 'raw',
            content: yield fstat(args, args.argvNoOptions[2], !!args.parsedOptions['with-data'], !!args.parsedOptions['enoent-ok'])
        };
    });
}
export default function (registrar) {
    registrar.listen('/vfs/_ls', lsImpl, {
        requiresLocal: true,
        flags: {
            boolean: ['A', 'a', 'd', 'c', 'C', 'l', 'h', 't', 'r', 's', 'S']
        }
    });
    registrar.listen('/vfs/_fstat', fstatImpl, {
        requiresLocal: true,
        flags: {
            boolean: ['with-data', 'enoent-ok']
        }
    });
    registrar.listen('/vfs/_fwrite', fwriteImpl, {
        requiresLocal: true
    });
    registrar.listen('/vfs/fslice', args => {
        return fslice(args.argvNoOptions[2], parseInt(args.argvNoOptions[3], 10), parseInt(args.argvNoOptions[4], 10), args.argvNoOptions[5]);
    }, { requiresLocal: true });
}
//# sourceMappingURL=server-side.js.map