import { Tab, PreloadRegistrar } from '@kui-shell/core';
import { Channel } from './channel';
export declare function getChannelForTab(tab: Tab): Promise<Channel>;
/**
 * Set it
 *
 */
export declare function setChannelForTab(tab: Tab, channel: Promise<Channel>): Promise<Channel>;
/**
 * Return the session for the given tab
 *
 */
export declare function getSessionForTab(tab: Tab): Promise<Channel>;
/**
 * Keep trying until we can establish a session
 *
 */
export declare function pollUntilOnline(tab: Tab): Promise<void>;
/** Connection to Kui proxy has been severed */
export declare function invalidateSession(tab: Tab): void;
/**
 * Initialize per-tab websocket session management
 *
 */
export declare function init(registrar: PreloadRegistrar): Promise<void>;
