var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
/*
 * Copyright 2021 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import * as assert from 'assert';
import { dirname, join } from 'path';
import { Common, CLI, Selectors } from '@kui-shell/test';
const ROOT = join(dirname(require.resolve('@kui-shell/plugin-bash-like/tests/data/grammy1.txt')), '..');
describe(`grammy table ${process.env.MOCHA_RUN_TARGET || ''}`, function () {
    before(Common.before(this));
    after(Common.after(this));
    it('should do grammy in the test file', () => __awaiter(this, void 0, void 0, function* () {
        try {
            const res = yield CLI.command(`grammy ${ROOT}/data/grammy1.txt`, this.app);
            const validRecordsInGrammy1 = 6;
            yield this.app.client.$(Selectors.TABLE_SHOW_AS_HISTOGRAM(res.count)).then(_ => _.waitForDisplayed());
            yield this.app.client.waitUntil(() => __awaiter(this, void 0, void 0, function* () {
                const labels = yield this.app.client.$$(Selectors.TABLE_HISTOGRAM_TEXT(res.count));
                return labels.length === validRecordsInGrammy1 * 2;
            }), { timeout: CLI.waitTimeout });
            yield this.app.client
                .$(Selectors.TABLE_HISTOGRAM_TEXT_WITH_ID('chart-axis-0-tickLabels-0', res.count))
                .then(text => assert.strictEqual(text, 'prepublish', `expect: prepublish; actual: ${text}`));
            yield this.app.client
                .$(Selectors.TABLE_HISTOGRAM_TEXT_WITH_ID('chart-bar-1-labels-0', res.count))
                .then(text => assert.strictEqual(text, '205', `expect: 205; actual: ${text}`));
            yield this.app.client
                .$(Selectors.TABLE_HISTOGRAM_TEXT_WITH_ID('chart-axis-0-tickLabels-1', res.count))
                .then(text => assert.strictEqual(text, 'publish suffix', `expect: publish suffix; actual: ${text}`));
        }
        catch (err) {
            return Common.oops(this, true);
        }
    }));
    it('should do grammy via globbing the test files', () => __awaiter(this, void 0, void 0, function* () {
        try {
            const res = yield CLI.command(`grammy ${ROOT}/data/grammy*`, this.app);
            yield this.app.client.$(Selectors.TABLE_SHOW_AS_HISTOGRAM(res.count)).then(_ => _.waitForDisplayed());
            yield this.app.client
                .$(Selectors.TABLE_HISTOGRAM_TEXT_WITH_ID('chart-bar-1-labels-0', res.count))
                .then(text => assert.strictEqual(text, '410', `expect: 410; actual: ${text}`));
        }
        catch (err) {
            return Common.oops(this, true);
        }
    }));
    it('should do grammy against pacakge.json and expect an empty table', () => __awaiter(this, void 0, void 0, function* () {
        try {
            const res = yield CLI.command(`grammy ${ROOT}/package.json`, this.app);
            yield this.app.client
                .$(Selectors.TABLE_SHOW_AS_HISTOGRAM(res.count))
                .then(_ => _.waitForDisplayed({ timeout: 8000, reverse: true }));
        }
        catch (err) {
            return Common.oops(this, true);
        }
    }));
});
//# sourceMappingURL=grammy.js.map