"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _pluginBashLike = require("@kui-shell/plugin-bash-like");

var _debug = _interopRequireDefault(require("debug"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*******************************************************************************
* Licensed Materials - Property of IBM
* (c) Copyright IBM Corporation 2019. All Rights Reserved.
*
* Note to U.S. Government Users Restricted Rights:
* Use, duplication or disclosure restricted by GSA ADP Schedule
* Contract with IBM Corp.
*******************************************************************************/

/*
 * Copyright (c) 2020 Red Hat, Inc.
 * Copyright Contributors to the Open Cluster Management project
 */
var __awaiter = void 0 && (void 0).__awaiter || function (thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function (resolve) {
      resolve(value);
    });
  }

  return new (P || (P = Promise))(function (resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }

    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }

    function step(result) {
      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
    }

    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
}; // command name changed since KUI v6
// import {dispatchToShell} from '@kui-shell/plugin-bash-like/dist/lib/cmds/catchall'


const debug = (0, _debug.default)('plugins/addons');
const bashLikeRoutes = ['/git/status', '/git/diff', '/lls'];
const k8sRoutes = ['/istio/install', '/istio/uninstall', '/istio/ingress', '/istio/status', '/bookinfo/install', '/bookinfo/uninstall', '/bookinfo/create', '/kiali/install', '/kiali/delete', '/kiali/console', '/kiali/graph', '/k8s/kedit', '/k8s/kdebug'];
const coreSupportRoutes = ['/run', '/window', '/window/bigger', '/window/smaller', '/window/max', '/window/unmax', '/window/close', '/quit']; //const otherRoutes = ['/export','/cd']
//const kuiRoutes = ['']

const blockKUICommand = (route, commandTree) => __awaiter(void 0, void 0, void 0, function* () {
  // using listen to block commands we specify
  commandTree.listen(route, () => 'Command is disabled'); // no command options needed in KUI v10 as noAuthOK true is the default
});

const rewriteLSCommand = commandTree => __awaiter(void 0, void 0, void 0, function* () {
  // using override to block
  const route = '/ls';
  commandTree.override(route, 'plugin-bash-like/fs', opts => {
    debug('ls dispatch to shell');
    return (0, _pluginBashLike.doExecWithPty)(opts);
  }, {}); // no command options needed in KUI v10 as noAuthOK true is the default
});

const rewriteExecCommand = commandTree => __awaiter(void 0, void 0, void 0, function* () {
  // using override to block
  const route = '/!';
  commandTree.override(route, 'plugin-bash-like', opts => {
    debug('! dispatch to shell');
    return (0, _pluginBashLike.doExecWithPty)(opts);
  }, {}); // no command options needed in KUI v10 as noAuthOK true is the default
});

const redirectHelp = commandTree => __awaiter(void 0, void 0, void 0, function* () {
  commandTree.listen('/help', ({
    REPL
  }) => {
    return REPL.qexec('getting started');
  }, {}); // no command options needed in KUI v10 as noAuthOK true is the default
});

var _default = commandTree => __awaiter(void 0, void 0, void 0, function* () {
  const allRoutes = [...bashLikeRoutes, ...k8sRoutes, ...coreSupportRoutes];
  return Promise.all([redirectHelp(commandTree), rewriteExecCommand(commandTree), rewriteLSCommand(commandTree), rewriteLSCommand(commandTree), ...allRoutes.map(route => blockKUICommand(route, commandTree))]);
});

exports.default = _default;