/*
 * Copyright 2017 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { isHeadless } from '@kui-shell/core';
// import help from './lib/cmds/help'
import echo from './lib/cmds/echo';
import quit from './lib/cmds/quit';
import clear from './lib/cmds/clear';
import dopar from './lib/cmds/dopar';
import watch from './lib/cmds/watch';
import base64 from './lib/cmds/base64';
import prompt from './lib/cmds/prompt';
import replay from './lib/cmds/replay';
import sleep from './lib/cmds/sleep';
import history from './lib/cmds/history/history';
import kuiConfig from './lib/cmds/kui-config';
import tabManagement from './lib/cmds/tab-management';
import grammy from './lib/cmds/grammy';
// import updater from './lib/admin/updater'
/**
 * This is the module
 *
 */
export default (commandTree) => __awaiter(void 0, void 0, void 0, function* () {
    yield Promise.all([
        // help(commandTree, options),
        echo(commandTree),
        quit(commandTree),
        clear(commandTree),
        commandTree.listen('/dopar', dopar),
        watch(commandTree),
        base64(commandTree),
        prompt(commandTree),
        replay(commandTree),
        sleep(commandTree),
        history(commandTree),
        kuiConfig(commandTree),
        grammy(commandTree),
        tabManagement(commandTree)
    ]);
    if (!isHeadless()) {
        yield Promise.all([
            import('./lib/cmds/zoom').then(_ => _.plugin(commandTree)),
            import('./lib/cmds/theme').then(_ => _.plugin(commandTree))
        ]);
    }
    // updater(commandTree) <-- disabled for now
});
//# sourceMappingURL=plugin.js.map