/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { Common, CLI, ReplExpect, Selectors } from '@kui-shell/test';
import { resetTheme } from './theme-common';
const altTheme = 'Carbon Gray90';
describe('theme switching via status stripe widget', function () {
    before(Common.before(this));
    after(Common.after(this));
    resetTheme(this);
    it(`should click on the theme widget and switch to ${altTheme}`, () => __awaiter(this, void 0, void 0, function* () {
        try {
            const widget = yield this.app.client.$('#kui--settings-widget button');
            yield widget.click();
            const menuItem = yield this.app.client.$(`${Selectors.STATUS_STRIPE} ${Selectors.DROPDOWN_MENU_ITEM_NAMED(altTheme)}`);
            yield menuItem.click();
        }
        catch (err) {
            yield Common.oops(this, true)(err);
        }
    }));
    it(`should show that we are using the ${altTheme} theme`, () => CLI.command('theme current', this.app)
        .then(ReplExpect.okWithString(altTheme))
        .catch(Common.oops(this, true)));
    resetTheme(this);
});
//# sourceMappingURL=theme-widget.js.map