/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { Common, CLI, ReplExpect, Selectors } from '@kui-shell/test';
function removeAndValidate(ctx, N) {
    return __awaiter(this, void 0, void 0, function* () {
        yield ctx.app.client.$(Selectors.PROMPT_N(N)).then(_ => _.moveTo());
        yield ctx.app.client.$(Selectors.BLOCK_REMOVE_BUTTON(N)).then(_ => {
            _.waitForDisplayed();
            _.moveTo();
            _.click();
        });
        yield ctx.app.client.waitUntil(() => __awaiter(this, void 0, void 0, function* () {
            const text = yield ctx.app.client.$(Selectors.OUTPUT_LAST).then(_ => _.getText());
            return text === 'hi';
        }));
    });
}
function doEchoThenRemove(idx) {
    it(`should echo ${idx} then remove that block`, () => __awaiter(this, void 0, void 0, function* () {
        try {
            const res = yield CLI.command(`echo ${idx}`, this.app);
            yield ReplExpect.okWithPtyOutput(idx.toString())(res);
            yield removeAndValidate(this, res.count);
        }
        catch (err) {
            yield Common.oops(this, true)(err);
        }
    }));
}
describe(`remove command block ${process.env.MOCHA_RUN_TARGET || ''}`, function () {
    before(Common.before(this));
    after(Common.after(this));
    const echo = doEchoThenRemove.bind(this);
    // here come the tests
    it('should echo hi', () => CLI.command('echo hi', this.app)
        .then(ReplExpect.okWithPtyOutput('hi'))
        .catch(Common.oops(this)));
    echo(1);
    echo(2);
    it(`should remove the block during sleep 30`, () => __awaiter(this, void 0, void 0, function* () {
        try {
            const res = yield CLI.command('sleep 30', this.app);
            yield removeAndValidate(this, res.count);
        }
        catch (err) {
            yield Common.oops(this, true)(err);
        }
    }));
});
//# sourceMappingURL=remove-block.js.map