import { Common } from '@kui-shell/test';
/** The actual split terminal via button impl; splitViaButton is the mocha test wrapper */
export declare function doSplitViaButton(ctx: Common.ISuite, splitCount: number): Promise<void>;
/** Split the terminal in the current tab by using the split button */
export declare function splitViaButton(this: Common.ISuite, splitCount: number): void;
/** Split the terminal in the current tab by using the "split" command */
export declare function splitViaCommand(this: Common.ISuite, splitCount: number, expectErr?: boolean, inverseColors?: boolean, where?: {
    spliceIndex: number;
    messageShouldAppearHere: number;
}): void;
/** Close the split in the current tab by using the "exit" command */
export declare function close(this: Common.ISuite, splitCount: number, inSplit: number): void;
/** Close the split in the current tab by clicking the close button */
export declare function closeViaButton(this: Common.ISuite, splitCount: number, inSplit: number): void;
/** Clear the split in the current tab by clicking the clear button */
export declare function clearViaButton(this: Common.ISuite, inSplit: number): void;
export declare function focus(this: Common.ISuite, toSplitIndex: number): void;
export declare function expectSplits(this: Common.ISuite, nSplits: number): void;
/** Click to focus the given split */
export declare function focusAndValidate(this: Common.ISuite, fromSplitIndex: number, toSplitIndex: number): void;
