var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
/*
 * Copyright 2018 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import { Common, CLI, ReplExpect, Selectors, Util } from '@kui-shell/test';
describe(`about command ${process.env.MOCHA_RUN_TARGET || ''}`, function () {
    before(Common.before(this));
    after(Common.after(this));
    Util.closeAllExceptFirstTab.bind(this)();
    it('should open the about window via command execution with comment', () => __awaiter(this, void 0, void 0, function* () {
        try {
            yield CLI.command('about #About Kui', this.app);
            yield this.app.client.$(Selectors.TAB_SELECTED_N(2)).then(_ => _.waitForDisplayed());
            yield this.app.client.waitUntil(() => __awaiter(this, void 0, void 0, function* () {
                const actualTitle = yield this.app.client.$(Selectors.TAB_TITLE_N(2)).then(_ => _.getText());
                return actualTitle === 'Welcome to Kui';
            }));
        }
        catch (err) {
            yield Common.oops(this, true)(err);
        }
    }));
    Util.closeAllExceptFirstTab.bind(this)();
    it('should open the about via button click', () => __awaiter(this, void 0, void 0, function* () {
        try {
            yield Common.refresh(this);
            yield this.app.client.$('#help-button').then(_ => _.waitForDisplayed());
            yield CLI.command('sleep 1', this.app).then(ReplExpect.blank);
            yield this.app.client.$('#help-button').then(_ => _.click());
            yield this.app.client.$(Selectors.TAB_SELECTED_N(2)).then(_ => _.waitForDisplayed());
            yield this.app.client.waitUntil(() => __awaiter(this, void 0, void 0, function* () {
                const actualTitle = yield this.app.client.$(Selectors.TAB_TITLE_N(2)).then(_ => _.getText());
                return actualTitle === 'Welcome to Kui';
            }), { timeout: CLI.waitTimeout });
        }
        catch (err) {
            yield Common.oops(this, true)(err);
        }
    }));
});
//# sourceMappingURL=about.js.map