var _excluded = ["listBoxMenuIconTranslationIds"];

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React from 'react';
import { action } from '@storybook/addon-actions';
import { boolean, object, select, text } from '@storybook/addon-knobs';
import ComboBox from '../ComboBox';
import mdx from './ComboBox.mdx';
var items = [{
  id: 'option-0',
  text: 'An example option that is really long to show what should be done to handle long text'
}, {
  id: 'option-1',
  text: 'Option 1'
}, {
  id: 'option-2',
  text: 'Option 2'
}, {
  id: 'option-3',
  text: 'Option 3'
}, {
  id: 'option-4',
  text: 'Option 4'
}, {
  id: 'option-5',
  text: 'Option 5'
}];
var sizes = {
  'Small  (sm)': 'sm',
  'Medium (md) - default': undefined,
  'Large  (lg)': 'lg'
};
var directions = {
  'Bottom (default)': 'bottom',
  'Top ': 'top'
};
export default {
  title: 'Components/ComboBox',
  component: ComboBox,
  parameters: {
    docs: {
      page: mdx
    }
  }
};
export var combobox = function combobox() {
  return /*#__PURE__*/React.createElement("div", {
    style: {
      width: 300
    }
  }, /*#__PURE__*/React.createElement(ComboBox, {
    onChange: function onChange() {},
    id: "carbon-combobox",
    items: items,
    itemToString: function itemToString(item) {
      return item ? item.text : '';
    },
    placeholder: "Filter...",
    titleText: "ComboBox title",
    helperText: "Combobox helper text"
  }));
};

var props = function props() {
  return {
    id: text('Combobox ID (id)', 'carbon-combobox-example'),
    placeholder: text('Placeholder text (placeholder)', 'Filter...'),
    titleText: text('Title (titleText)', 'Combobox title'),
    helperText: text('Helper text (helperText)', 'Optional helper text here'),
    light: boolean('Light (light)', false),
    disabled: boolean('Disabled (disabled)', false),
    invalid: boolean('Invalid (invalid)', false),
    invalidText: text('Invalid text (invalidText)', 'A valid value is required'),
    size: select('Field size (size)', sizes, undefined) || undefined,
    direction: select('Dropdown direction (direction)', directions, 'bottom'),
    onChange: action('onChange'),
    onToggleClick: action('onClick'),
    warn: boolean('Show warning state (warn)', false),
    warnText: text('Warning state text (warnText)', 'This mode may perform worse on older machines'),
    listBoxMenuIconTranslationIds: object('Listbox menu icon translation IDs (for translateWithId callback)', {
      'close.menu': 'Close menu',
      'open.menu': 'Open menu',
      'clear.selection': 'Clear selection'
    })
  };
};

export var Playground = function Playground() {
  var _props = props(),
      listBoxMenuIconTranslationIds = _props.listBoxMenuIconTranslationIds,
      comboBoxProps = _objectWithoutProperties(_props, _excluded);

  return /*#__PURE__*/React.createElement("div", {
    style: {
      width: 300
    }
  }, /*#__PURE__*/React.createElement(ComboBox, _extends({}, comboBoxProps, {
    items: items,
    itemToString: function itemToString(item) {
      return item ? item.text : '';
    },
    translateWithId: function translateWithId(id) {
      return listBoxMenuIconTranslationIds[id];
    }
  })));
};
export var disabled = function disabled() {
  return /*#__PURE__*/React.createElement("div", {
    style: {
      width: 300
    }
  }, /*#__PURE__*/React.createElement(ComboBox, {
    onChange: function onChange() {},
    id: "carbon-combobox-disabled",
    disabled: true,
    items: items,
    itemToString: function itemToString(item) {
      return item ? item.text : '';
    },
    placeholder: "Filter...",
    titleText: "ComboBox title",
    helperText: "Combobox helper text"
  }));
};
export var light = function light() {
  return /*#__PURE__*/React.createElement("div", {
    style: {
      width: 300
    }
  }, /*#__PURE__*/React.createElement(ComboBox, {
    onChange: function onChange() {},
    id: "carbon-combobox-light",
    light: true,
    items: items,
    itemToString: function itemToString(item) {
      return item ? item.text : '';
    },
    placeholder: "Filter...",
    titleText: "ComboBox title",
    helperText: "Combobox helper text"
  }));
};