function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React from 'react';
import { withKnobs, boolean, select, text, array } from '@storybook/addon-knobs';
import { action } from '@storybook/addon-actions';
import DatePicker from '../DatePicker';
import DatePickerInput from '../DatePickerInput';
import DatePickerSkeleton from '../DatePicker/DatePicker.Skeleton';
import mdx from './DatePicker.mdx';
var patterns = {
  'Short (d{1,2}/d{4})': '\\d{1,2}/\\d{4}',
  'Regular (d{1,2}/d{1,2}/d{4})': '\\d{1,2}/\\d{1,2}/\\d{4}'
};
var sizes = {
  'Small  (sm)': 'sm',
  'Medium (md) - default': undefined,
  'Large  (lg)': 'lg'
};
var types = {
  Simple: 'simple',
  Single: 'single',
  Range: 'range'
};
var props = {
  datePicker: function datePicker() {
    return {
      dateFormat: text('The date format (dateFormat in <DatePicker>)', 'm/d/Y'),
      id: 'date-picker',
      light: boolean('Light variant (light in <DatePicker>)', false),
      datePickerType: select('Date Picker Type (datePickerType)', types, 'single'),
      minDate: text('Disable dates before this date (minDate)', '11/15/2020'),
      maxDate: text('Disabled dates after this date (maxDate)', '11/01/2040'),
      disable: array('Disable specific dates (disable)', ['07/15/2021'], ','),
      onClose: action('onClose'),
      onOpen: action('onOpen'),
      onChange: action('onChange')
    };
  },
  datePickerInput: function datePickerInput() {
    return {
      id: 'date-picker-input-id',
      className: 'some-class',
      size: select('Field size (size)', sizes, undefined) || undefined,
      labelText: text('Label text (labelText in <DatePickerInput>)', 'Date Picker label'),
      pattern: select('The date format (pattern in <DatePickerInput>)', patterns, 'd{1,2}/d{4}'),
      placeholder: text('Placeholder text (placeholder in <DatePickerInput>)', 'mm/dd/yyyy'),
      disabled: boolean('Disabled (disabled in <DatePickerInput>)', false),
      helperText: text('Helper text (helperText)', 'Optional help text'),
      invalid: boolean('Show form validation UI (invalid in <DatePickerInput>)', false),
      invalidText: text('Form validation UI content (invalidText in <DatePickerInput>)', 'A valid date is required'),
      warn: boolean('Show warning state (warn)', false),
      warnText: text('Warning state text (warnText)', 'Selected dates may cause conflicts'),
      iconDescription: text('Icon description (iconDescription in <DatePickerInput>)', 'Icon description'),
      onChange: action('onChange')
    };
  }
};
export default {
  title: 'Components/DatePicker',
  decorators: [withKnobs],
  parameters: {
    component: DatePicker,
    subcomponents: {
      DatePickerInput: DatePickerInput,
      DatePickerSkeleton: DatePickerSkeleton
    },
    docs: {
      page: mdx
    }
  }
};
export var Simple = function Simple() {
  return /*#__PURE__*/React.createElement(DatePicker, {
    datePickerType: "simple"
  }, /*#__PURE__*/React.createElement(DatePickerInput, {
    placeholder: "mm/dd/yyyy",
    labelText: "Date Picker label",
    id: "date-picker-simple"
  }));
};
Simple.storyName = 'simple';
export var Single = function Single() {
  return /*#__PURE__*/React.createElement(DatePicker, {
    datePickerType: "single"
  }, /*#__PURE__*/React.createElement(DatePickerInput, {
    placeholder: "mm/dd/yyyy",
    labelText: "Date Picker label",
    id: "date-picker-single"
  }));
};
Single.storyName = 'single with calendar';
export var Range = function Range() {
  return /*#__PURE__*/React.createElement(DatePicker, {
    datePickerType: "range"
  }, /*#__PURE__*/React.createElement(DatePickerInput, {
    id: "date-picker-input-id-start",
    placeholder: "mm/dd/yyyy",
    labelText: "Start date"
  }), /*#__PURE__*/React.createElement(DatePickerInput, {
    id: "date-picker-input-id-finish",
    placeholder: "mm/dd/yyyy",
    labelText: "End date"
  }));
};
Range.storyName = 'range with calendar';
export var DatePickerPlayground = function DatePickerPlayground() {
  return /*#__PURE__*/React.createElement(DatePicker, props.datePicker(), /*#__PURE__*/React.createElement(DatePickerInput, props.datePickerInput()), props.datePicker().datePickerType === 'range' && /*#__PURE__*/React.createElement(DatePickerInput, _extends({}, props.datePickerInput(), {
    id: "date-picker-input-2"
  })));
};
export var Skeleton = function Skeleton() {
  return /*#__PURE__*/React.createElement(DatePickerSkeleton, {
    range: true
  });
};
Skeleton.storyName = 'skeleton';